# Diverse Querying Improves Deep Active Anomaly Detection

This repository provides a PyTorch implementation of our submission. This code is shared for review purposes only. Do not copy, reproduce, share, publish, or use for any purpose except to review our submission. Please delete after the review process. The authors plan to publish the code deanonymized and with a proper license upon publication of the paper.

## Reproduce the Results

This repo contains the code of experiments with ALOE on image data. The backbone model is MHRot. Please note the code will automatically download datasets into `./data/`.

Please run the command to reproduce the results when $K=20$ and anomaly rate equals 10%:

```
## CIFAR-10 ##
# ALOE
python train_ad.py --dataset=cifar10 --epochs=16 --lr=1e-3 --oe_rank=latent_gauss --foldername=cifar10_ALOE_res/ --oe=True --oe_loss=weighted  --K=20 

# Hybr1
python train_ad.py --dataset=cifar10 --epochs=16 --lr=1e-3 --foldername=cifar10_Hybr1_res/ --query_strategy=hybr1 --K=20

# Hybr2
python train_ad.py --dataset=cifar10 --epochs=16 --lr=1e-3 --foldername=cifar10_Hybr2_res/  --oe_loss=supervise --query_strategy=hybr2 --K=20

## FMNIST ##
# ALOE
python train_ad.py --dataset=fmnist --epochs=3 --lr=1e-4 --oe_rank=training_obj --foldername=fmnist_ALOE_res/ --oe=True --oe_loss=weighted --K=20

# Hybr1
python train_ad.py --dataset=fmnist --epochs=15 --lr=1e-4 --foldername=fmnist_Hybr1_res/  --query_strategy=hybr1 --K=20

# Hybr2
python train_ad.py --dataset=fmnist --epochs=15 --lr=1e-4 --foldername=fmnist_Hybr2_res/ --oe_loss=supervise --query_strategy=hybr2 --K=20

## MedMNIST ##
# ALOE
python train_ad.py --dataset=$1 --epochs=15 --lr=1e-4 --oe_rank=training_obj --foldername=$1_ALOE_res/ --oe=True --oe_loss=weighted --K=20

# hybr1
python train_ad.py --dataset=$1 --epochs=15 --lr=1e-4 --foldername=$1_Hybr1_res/  --query_strategy=hybr1 --K=20

# Hybr2
python train_ad.py --dataset=$1 --epochs=15 --lr=1e-4 --foldername=$1_Hybr2_res/ --oe_loss=supervise --query_strategy=hybr2 --K=20
```

For MedMNIST, `$1` is the placeholder for the following options:`blood`, `organa`, `organc`, `organs`.
