export CUDA_VISIBLE_DEVICES=0

model_name=RAYQUAZA



################################ 96 ###########################################
python3 -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path ETTm2.csv \
    --model_id ETTm2_96 \
    --model $model_name \
    --data ETTm2 \
    --features S \
    --seq_len 336 \
    --label_len 48 \
    --pred_len 96 \
    --e_layers 12 \
    --d_layers 3 \
    --factor 1 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 1 \
    --des 'Exp' \
    --itr 1\
    --hidden_size 256 \
    --skip_alpha 0 \
    --K_short 12 \
    --channels 128 \
    --kernel 12 \
    --num_blocks 1 \
    --hidden_dim 12

################################ 192 ###########################################

python3 -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path ETTm2.csv \
    --model_id ETTm2_192 \
    --model $model_name \
    --data ETTm2 \
    --features S \
    --seq_len 336 \
    --label_len 48 \
    --pred_len 192 \
    --e_layers 12 \
    --d_layers 3 \
    --factor 1 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 1 \
    --des 'Exp' \
    --itr 1\
    --hidden_size 64 \
    --skip_alpha 0 \
    --K_short 12 \
    --channels 128 \
    --kernel 11 \
    --num_blocks 3 \
    --hidden_dim 12

################################ 336 ###########################################

python3 -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path ETTm2.csv \
    --model_id ETTm2_336 \
    --model $model_name \
    --data ETTm2 \
    --features S \
    --seq_len 336 \
    --label_len 48 \
    --pred_len 336 \
    --e_layers 12 \
    --d_layers 3 \
    --factor 1 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 1 \
    --des 'Exp' \
    --itr 1\
    --hidden_size 64 \
    --skip_alpha 0 \
    --K_short 8 \
    --channels 64 \
    --kernel 7 \
    --num_blocks 2 \
    --hidden_dim 12


################################ 720 ###########################################

python3 -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path ETTm2.csv \
    --model_id ETTm2_720 \
    --model $model_name \
    --data ETTm2 \
    --features S \
    --seq_len 336 \
    --label_len 48 \
    --pred_len 720 \
    --e_layers 12 \
    --d_layers 3 \
    --factor 1 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 1 \
    --des 'Exp' \
    --itr 1\
    --hidden_size 64 \
    --skip_alpha 0 \
    --K_short 8 \
    --channels 256 \
    --kernel 2 \
    --num_blocks 3 \
    --hidden_dim 12

