export CUDA_VISIBLE_DEVICES=0

model_name=RAYQUAZA

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Monthly' \
#   --model_id m4_Monthly \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Yearly' \
#   --model_id m4_Yearly \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Quarterly' \
#   --model_id m4_Quarterly \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Weekly' \
#   --model_id m4_Weekly \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Daily' \
#   --model_id m4_Daily \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'

# python -u run.py \
#   --task_name short_term_forecast \
#   --is_training 1 \
#   --root_path ./dataset/m4 \
#   --seasonal_patterns 'Hourly' \
#   --model_id m4_Hourly \
#   --model $model_name \
#   --data m4 \
#   --features M \
#   --e_layers 2 \
#   --d_layers 1 \
#   --factor 3 \
#   --enc_in 1 \
#   --dec_in 1 \
#   --c_out 1 \
#   --hidden_size 1 \
#   --num_layers 1\
#   --activation_order 3\
#   --batch_size 16 \
#   --d_model 512 \
#   --des 'Exp' \
#   --itr 1 \
#   --learning_rate 0.001 \
#   --loss 'SMAPE'




channels=128
kernel=8
num_blocks=2
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Weekly' \
  --model_id m4_Weekly \
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --d_model 512 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 128 \
  --skip_alpha 0.1 \
  --K_short 12 \
  --channels 128 \
  --kernel 3 \
  --num_blocks 2 \
  --c_out 1 \
  --hidden_dim 12

channels=128
kernel=8
num_blocks=2
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Daily' \
  --model_id m4_Daily \
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --d_model 512 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 128 \
  --skip_alpha 0.001 \
  --K_short 12 \
  --channels 16 \
  --kernel 3 \
  --num_blocks $num_blocks \
  --c_out 1 \
  --hidden_dim 12


channels=128
kernel=8
num_blocks=2
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Hourly' \
  --model_id m4_Hourly \
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 256 \
  --skip_alpha 1 \
  --K_short 12 \
  --channels 128 \
  --kernel 3 \
  --num_blocks $num_blocks \
  --c_out 1 \
  --hidden_dim 6




channels=256
kernel=3
num_blocks=2
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Yearly'\
  --model_id m4_Yearly\
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --d_model 512 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 128 \
  --skip_alpha 1 \
  --K_short 32 \
  --channels $channels \
  --kernel 3 \
  --num_blocks $num_blocks \
  --c_out 1 \
  --hidden_dim 12



channels=256
kernel=2
num_blocks=2
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Quarterly'\
  --model_id m4_Quarterly\
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --d_model 512 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 128 \
  --skip_alpha 0.1\
  --K_short 32 \
  --channels $channels \
  --kernel 12 \
  --num_blocks $num_blocks \
  --c_out 1 \
  --hidden_dim 12



channels=128
kernel=2
num_blocks=6
skip_alpha=0.5
hidden_size=256

python3 -u run.py \
  --task_name short_term_forecast \
  --is_training 1 \
  --root_path ./dataset/m4 \
  --seasonal_patterns 'Monthly'\
  --model_id m4_Monthly\
  --model $model_name \
  --data m4 \
  --features M \
  --batch_size 16 \
  --d_model 512 \
  --des 'Exp' \
  --itr 1 \
  --learning_rate 0.001 \
  --loss 'SMAPE'\
  --hidden_size 128 \
  --skip_alpha 0.001\
  --K_short 32 \
  --channels $channels \
  --kernel 64 \
  --num_blocks $num_blocks \
  --c_out 1 \
  --hidden_dim 12