## contains code for notation that should remain consistent across experiments


class NotationConfig:
    def __init__(self, failure_representation=None):
        if failure_representation is None:
            self.failure_representation = {"1": "$\u0058$", "0": "$\u2714$"}

        self.outcome_name = "Outcome Profile"
        self.input_name = "Instance"

        self.by_human_accuracy_semantic_dict = {
            0.0: "Humans both correct",
            0.5: "1 human correct, 1 human incorrect",
            1.0: "Humans both incorrect",
        }

        self.by_human_confidence_semantic_dict = {
            0.0: "Humans predict benign",
            0.5: "Humans disagree",
            1.0: "Humans predict malignant",
        }

        self.semantic_dicts = {
            "failure": self.failure_representation,
            "by_human_accuracy": self.by_human_accuracy_semantic_dict,
        }

    def semantically_convert_list(self, lst, semantic_dict_name="failure"):
        semantic_list = []
        for s in lst:
            semantic_list.append(
                self.semantically_convert_string(s, semantic_dict_name)
            )
        return semantic_list

    def semantically_convert_string(self, s, semantic_dict_name="failure"):
        semantic_string = ""
        semantic_dict = self.semantic_dicts[semantic_dict_name]
        for char in s:
            semantic_string += semantic_dict.get(
                char, char
            )  # appends original char if char not in dict
        return semantic_string
