# Statistical Analysis of the Sinkhorn Iterations for Two-Sample Schrödinger Bridge Estimation

This repository contains experiments to evaluate the convergence rate of the Sinkhorn Bridge estimator for the Schrödinger Bridge, based on i.i.d. samples from source and target distributions.

## Reproducing the Experiments

All figures in the paper can be regenerated from the notebooks in the `notebooks/` folder.

| Notebook                           | Paper Figure | What it Shows                                                                                              |
| ---------------------------------- | ------------ | ---------------------------------------------------------------------------------------------------------- |
| `01_statistical_convergence.ipynb` | Fig. 1      | Heat-maps of $\text{MSE}_{\text{sample}}(m,n,t)$ illustrating the $(m \wedge n)^{-1}$ rate predicted by Theorem 1     |
| `02_algorithmic_convergence.ipynb` | Fig. 2       | Exponential decay of the integrated MSE versus the Sinkhorn iteration $k$                                |
| `03_sinkhorn_and_neural_drift.ipynb`            | Fig. 3       | Estimated drift after several Sinkhorn iterations, drift of the optimal Sinkhorn Bridge estimator, and simulation results using neural network–approximated drift            |

Once you run each notebook, the plots will be generated under the `fig/` directory.

## Basic usage

You can recreate the development environment used in this study by following the steps below:

```bash
curl -LsSf https://astral.sh/uv/install.sh | sh
source ~/.bashrc   # or source ~/.zshrc, etc.
uv sync
source .venv/bin/activate
```

The above steps will automatically install the required dependencies, allowing you to immediately reproduce the experimental results in the paper.
