import logging

from .Basic import BasicFormatter
from .nlp.BasicBertFormatter import BasicBertFormatter
from .nlp.BasicREFormatter import BasicREFormatter, CnnREFormatter, BertREFormatter
from .nlp.BasicETFormatter import BasicETFormatter, CnnETFormatter, BertETFormatter
from .nlp.BasicIRFormatter import BasicIRFormatter, CnnIRFormatter, BertIRFormatter

logger = logging.getLogger(__name__)

formatter_list = {
    "Basic": BasicFormatter,
    "BasicBert": BasicBertFormatter,
    "BasicRE": BasicREFormatter,
    "CnnRE": CnnREFormatter,
    "BertRE": BertREFormatter,
    "BasicET": BasicETFormatter,
    "CnnET": CnnETFormatter,
    "BertET": BertETFormatter,
    "BasicIR": BasicIRFormatter,
    "CnnIR": CnnIRFormatter,
    "BertIR": BertIRFormatter,
}


def init_formatter(config, mode, *args, **params):
    temp_mode = mode
    if mode != "train":
        try:
            config.get("data", "%s_formatter_type" % temp_mode)
        except Exception as e:
            logger.warning(
                "[reader] %s_formatter_type has not been defined in config file, use [dataset] train_formatter_type instead." % temp_mode)
            temp_mode = "train"
    which = config.get("data", "%s_formatter_type" % temp_mode)

    if which in formatter_list:
        formatter = formatter_list[which](config, mode, *args, **params)

        return formatter
    else:
        logger.error("There is no formatter called %s, check your config." % which)
        raise NotImplementedError
