import torch
import os
import gc

global_emb = {}

def check_cache(filename):
    if filename in global_emb:
        return True, global_emb[filename]
    if os.path.exists(filename+"_cache"):
        obj = torch.load(filename+"_cache")
        if "128" in filename:
            new_embs = {}
            with open("/data2/private/zzy/ke_exp/datasets/clueweb09/ents.txt", 'r') as fin:
                for line in fin:
                    eid = int(line.strip())
                    new_embs[eid] = obj[eid]
            global_emb[filename] = new_embs
            gc.collect()
        else:
            global_emb[filename] = obj
        print("Loaded!")
        return True, obj
    else:
        return False, None

def save_cache(filename, data):
    torch.save(data, filename+"_cache")
    global_emb[filename] = data

