from .nlp.BasicBert import BasicBert
from .nlp.BasicRE import BasicRE, CnnRE, CnnKFRE, CnnKARE, LstmRE, LstmKFRE, LstmKARE, BertRE, BertKFRE, BertKARE
from .nlp.BasicET import BasicET, CnnET, CnnKFET, LstmET, BertET, BertKFET, BertKAET, LstmKFET, LstmKAET, CnnKAET
from .nlp.BasicIR import CnnIR, LstmIR, BertIR, BasicIR, CnnKFIR, LstmKFIR, CnnKAIR, LstmKAIR, BertKFIR, BertKAIR

model_list = {
    "BasicBert": BasicBert,
    "BasicRE": BasicRE,
    "CnnRE": CnnRE,
    "CnnKFRE": CnnKFRE,
    "CnnKARE": CnnKARE,
    "LstmRE": LstmRE,
    "LstmKFRE": LstmKFRE,
    "LstmKARE": LstmKARE,
    "BertRE": BertRE,
    "BertKFRE": BertKFRE,
    "BertKARE": BertKARE,
    "BasicET": BasicET,
    "CnnET": CnnET,
    "LstmET": LstmET,
    "CnnKFET": CnnKFET,
    "BertET": BertET,
    "BertKFET": BertKFET,
    "BertKAET": BertKAET,
    "LstmKFET": LstmKFET,
    "LstmKAET": LstmKAET,
    "CnnKAET": CnnKAET,
    "BasicIR": BasicIR,
    "CnnIR": CnnIR,
    "LstmIR": LstmIR,
    "BertIR": BertIR,
    "CnnKFIR": CnnKFIR,
    "LstmKFIR": LstmKFIR,
    "CnnKAIR": CnnKAIR,
    "LstmKAIR": LstmKAIR,
    "BertKFIR": BertKFIR,
    "BertKAIR": BertKAIR,
}


def get_model(model_name):
    if model_name in model_list.keys():
        return model_list[model_name]
    else:
        raise NotImplementedError
