# `MAQuE` 🩺
> Code files for the paper `The Dialogue That Heals: A Comprehensive Evaluation of Doctor Agent's Inquiry Capability`.

This repository contains the official implementation for the `MAQuE` benchmark, designed to rigorously evaluate the inquiry (questioning) capabilities of Doctor Agents in a medical dialogue setting.

## How to use
- To modify config settings, edit the `config.cfg` file.

- To run the benchmark, execute `python src/main.py`.

## File Structure
```python
MAQuE/                                 # Project Root
├── data/                              # Stores project data
│   ├── figures/                       # Figures in the paper
│   └── profiles/                      # MAQuE dataset
├── src/                               # Source Code
│   ├── doctor/                        # Doctor modules
│   ├── evaluators/                    # Evaluation modules
│   ├── patient/                       # Patient modules
│   └── utils/                         # Utility functions
├── dialogue_manager.py                # Controls dialogue flow
├── main.py                            # Main entry
├── maque.py                           # Core project script
└── config.cfg                         # Configuration file
```