from utils.myutils import doctorMessage, patientMessage, systemMessage
import datetime

class DialogueManager:
    def __init__(self, config):
        self.config = config

    def interact(self, doctor, patient):
        max_rounds = int(self.config.get('doctor', 'max_questions'))
        doctor_time = datetime.timedelta(0)
        patient_time = datetime.timedelta(0)
        
        answer = None # initially, the doctor has no information from the patient
        for i in range(max_rounds + 1):

            # doctor asks a question or decides to end the consultation
            ask_start_time = datetime.datetime.now()
            for _ in range(3): # retry up to 3 times if the doctor fails to ask a question
                question = doctor.ask(answer)
                if question:
                    break

            ask_end_time = datetime.datetime.now()
            doctor_time += ask_end_time - ask_start_time
            
            if question is None: # doctor decides to end the consultation
                break
            elif i == max_rounds: # reach max rounds and still has question
                patient.truncated = True
                break
            
            systemMessage("————————")
            systemMessage("Round: " + str(i + 1))
            doctorMessage("doctor: " + question)
            
            # patient answers the question
            answer_start_time = datetime.datetime.now()
            answer = patient.answer(question)
            answer_end_time = datetime.datetime.now()
            patient_time += answer_end_time - answer_start_time
            
            patientMessage("patient: " + answer)

        doctor.time = doctor_time.total_seconds()
        patient.time = patient_time.total_seconds()
        return doctor_time.total_seconds(), patient_time.total_seconds()