from utils.myutils import AIClient
class Doctor:
    """
    The doctor class is responsible for responding to patient answers.
    """
    def __init__(self, config, task, choices):
        self.config = config
        self.task = task
        self.information = None
        self.choices = choices
        self.client = AIClient(model=self.config.get("doctor", "model"), max_tokens=128)
        self.additional_info = None

    def ask(self, answer):
        """
        Ask the patient a question based on the patient's answer.
        """
        return NotImplementedError("The ask method must be implemented in the subclass.")