from .base import Doctor
from utils.myutils import doctorMessage

class DoctorHistory(Doctor):
    def __init__(self, config, task, choices):
        super().__init__(config, task, choices)

        self.history = []
        self.max_rounds = int(self.config.get('doctor', 'max_questions'))

    def ask(self, answer):
        if answer is not None:
            self.history.append({"role": "user", "content": answer})
        else:
            self.history.append({"role": "user", "content": "The consultation begins."})
        
        system_prompt = (
            "You are a medical professional in medical inquiry. "
            "You ask questions to gather information for diagnosis."
            f"Possible questions include demographics, symptoms, medical history, family "
            f"history, physical exam findings, lab results, and lifestyle. "
            
            # Flexible setting
            "If you think the collected information is sufficient for a diagnosis "
            f"among the following choices: {', '.join(self.choices)}, "
            f"respond with \"end consultation\" to stop the inquiry. "
            f"If not, ask **ONE** question a turn, balancing information acquisition, "
            
            # Fixed round setting
            # f"Possible diagnosis choices are: {', '.join(self.choices)}. "
            # f"You must ask {self.max_rounds} questions in total. "
            # "Ask **ONE** question a turn, balancing information acquisition, "
            
            "dialogue quality, inquiry efficiency, and patient experience. "
            "Never provide diagnosis, treatment plans or any other suggestions. "
        )
    
        messages = [
            {"role": "system", "content": system_prompt}
        ] + self.history
        
        new_question = self.client.get_response(messages=messages)
        
        if 'end consultation' in new_question.lower() or new_question.strip() == '':
            return None
        elif len(self.history) >= self.max_rounds * 2: # for truncated proportion calculation
            return "Exceed the maximum number of rounds"
        
        self.history.append({"role": "assistant", "content": new_question})
        doctorMessage(f"Doctor: {new_question}")
        return new_question