import importlib
from utils.myutils import errorMessage

def load_evaluator(dimension: str, config=None, save_folder=None):
    """
    - dimension='accuracy' -> evaluators.accuracy.AccuracyEvaluator
    - dimension='info_quality' -> evaluators.info_quality.InfoQualityEvaluator
    """
    def snake_to_pascal(name) -> str:
        if name is None:
            errorMessage("[Evaluator Load Warning] Dimension name is None.")
        return ''.join(word.capitalize() for word in name.split('_'))
    
    try:
        module = importlib.import_module(f".{dimension}", package=__name__)
        class_name = snake_to_pascal(dimension) + "Evaluator"
        evaluator_class = getattr(module, class_name)
        return evaluator_class(config, save_folder)
    except (ImportError, AttributeError) as e:
        errorMessage(f"[Evaluator Load Warning] Failed to load '{dimension}': {e}")
        return None
