from utils.myutils import AIClient

class Patient:
    def __init__(self, config, data):
        self.config = config
        self.task = data['task']
        self.category = data['category']
        
        self.answers = []
        self.questions = []
        self.truncated = False
        
        self.case_id = data['case_id']
        self.choices = data['choices'] if 'choices' in data else None
        self.ground_truth = data['answer']
        self.informtion = data['information']
        self.atom_information = data['atomized_information'] if 'atomized_information' in data else None
        
        self.client = AIClient(config.get('patient', 'model'))
        self.additional_info = {}
        
    def answer(self, question):
        return NotImplementedError("The method 'answer' must be implemented in the child class.")
    
    def get_answers(self):
        return self.answers
            
    def get_questions(self):
        return self.questions