import json
from .base import Patient

class PatientDefault(Patient):
    """
    The default patient class that provides answer to the seeker's question.
    """
    def __init__(self, config, data):
        super().__init__(config, data)

    def answer(self, question):
        """
        Provide an answer to the seeker's question based on the patient's context data.
        """
        if not question:
            return "Sorry, I didn't understand the question. Could you please rephrase it?"

        self.questions.append(question)

        system_prompt = (
            "You are a patient in a hospital, answering a doctor's questions based only on the provided context. "
            "Use first person pronouns like 'I' or 'my' to refer to yourself. "
            "Only reveal the information that is directly asked for. "
            "Do NOT provide any extra information beyond what is asked or what is in the context. "
            "If there's no relevant information in the context paragraph, "
            "express your uncertainty instead of making assumptions. "
        )
        
        user_prompt = (
            f"Inquiry History: \n{"\n".join([f"Q: {q}\nA: {a}" for q, a in zip(self.questions, self.answers)])}\n\n"
            f"New question: \n\"{question}\"\n\n"
            "Your context paragraph:\n"
            f"{json.dumps(self.informtion, indent=2)}"
        )

        messages = [
            {"role": "system", "content": system_prompt},
            {"role": "user", "content": user_prompt}
        ]
        
        new_answer = self.client.get_response(messages).strip()
        
        self.answers.append(new_answer)
        return new_answer
