import configparser

class ConfigLoader:
    def __init__(self, config_path):
        self.config = configparser.ConfigParser()
        self.config.read(config_path)

    def get(self, section, key):
        return self.config[section][key]

    def get_section(self, section):
        return dict(self.config.items(section))
    
    def get_all_configs(self):
        non_empty_values = {}
        for section in self.config.sections():
            section_data = {
                key: value for key, value in self.config.items(section) if value.strip()
            }
            if section_data:
                non_empty_values[section] = section_data
        return non_empty_values
    
    def to_dict(self):
        return {section: dict(self.config.items(section)) for section in self.config.sections()}

    @staticmethod
    def from_dict(config_dict):
        instance = ConfigLoader.__new__(ConfigLoader)
        instance.config = configparser.ConfigParser()
        for section, values in config_dict.items():
            instance.config.add_section(section)
            for key, value in values.items():
                instance.config.set(section, key, value)
        return instance
