#!/bin/bash

# Define arrays of parameters
lmbda_vals=(0.001 0.01 0.1)
k_regs=(3 5 7)

for lmbda in "${lmbda_vals[@]}"; do
    # Loop over each k_reg value
    for kreg in "${k_regs[@]}"; do

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type exp --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.4 --c_gap 0.4 --cl_gap 0.7 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type exp --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.8 --c_gap 0.8 --cl_gap 1.1 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type poly --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.55 --c_gap 0.55 --cl_gap 0.9 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type poly --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.5 --c_gap 0.5 --cl_gap 1.05 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type major --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.45 --c_gap 0.45 --cl_gap 0.8 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar10 -ar resnet20 -s 10 --imb_type major --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 500 --bins 10 --t_gap 0.5 --c_gap 0.5 --cl_gap 0.85 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes


        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type exp --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.52 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type exp --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.56 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type poly --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.63 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type poly --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.59 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type major --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.52 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset cifar100 -ar resnet20 -s 10 --imb_type major --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 50 --bins 25 --t_gap 0.3 --c_gap 0.45 --cl_gap 0.5 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes


        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type exp --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.35 --c_gap 0.75 --cl_gap 0.8 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type exp --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.6 --c_gap 0.9 --cl_gap 0.9 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type poly --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.35 --c_gap 0.6 --cl_gap 0.6 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type poly --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.5 --c_gap 0.8 --cl_gap 0.95 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type major --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.5 --c_gap 0.9 --cl_gap 0.85 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset mini -ar resnet20 -b 128 -s 10 --imb_type major --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 150 --bins 25 --t_gap 0.5 --c_gap 0.8 --cl_gap 0.75 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes


        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type exp --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.45 --c_gap 0.9 --cl_gap 0.75 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type exp --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.45 --c_gap 0.95 --cl_gap 0.9 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type poly --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.45 --c_gap 0.85 --cl_gap 0.75 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type poly --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.45 --c_gap 0.8 --cl_gap 0.8 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type major --rho 0.5 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.5 --c_gap 0.85 --cl_gap 0.8 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes
        python -W ignore ICP/main_new3.py --alpha 0.1 --dataset food -ar resnet20 -b 256 -s 10 --imb_type major --rho 0.1 --epochs 200 --loss_type LDAM --gpu 1 -score_functions RAPS -methods MCP CCP k-CCP cluster_CP -seeds 0 1 2 3 4 5 6 7 8 9 --calibration_sampling balanced -avg_num_per_class 125 --bins 25 --t_gap 0.45 --c_gap 0.7 --cl_gap 0.85 --lmbda_val ${lmbda} --k_reg ${kreg} --all yes

    done
done



