Reproducibility
===============

We included our code in the `impl` directory. It requires Python 3.6 or higher to run.
You can install the Python module `tgan_sr` by executing

    pip install -e .

in the `impl` directory. This will fetch all dependencies like tensorflow.

From there on, we assume the supplementary main folder is your current working directory.
Datasets are already provided in the `datasets` folder, but can also be generated from scratch.


Base dataset generation
-----------------------
To check the satisfiability of generated instances, you need to obtain the `aalta` tool from [bitbucket](https://bitbucket.org/jl86/aalta) (earliest commit in that repository).
Ensure that the binary `aalta` resides in the `bin` folder.

The raw dataset is produced by

    python -m tgan_sr.data_generation.generator -od datasets/LTLbase --splits all_raw:1 --timeout 2 -nv 10 -ne 1600000 -ts 50 --log-each-x-percent 1 --frac-unsat None

(rename to not override the supplied dataset).

Figures 5 and 6 (formula and satisfiability distributions) are created with

    python -m tgan_sr.utils.analyze_dataset all_raw.txt formula,sat

To filter the dataset

    python -m tgan_sr.utils.update_dataset all_raw.txt unique - | python -m tgan_sr.utils.update_dataset - balance_per_size all_balanced.txt

Calculate relaxed satisfiability (optional)

    python -m tgan_sr.utils.update_dataset all_balanced.txt relaxed_sat all_balanced_rs.txt

Create figures 7 and 8

    python -m tgan_sr.utils.analyze_dataset all_balanced_rs.txt formula,sat+relaxed


Split the data into training and validation sets

    python -m tgan_sr.utils.update_dataset all_balanced_rs.txt shuffle+split=train:8,val:1,test:1



Experiments
-----------
The folder `configs` contains JSON files for each type of experiment. Settings for different hyperparameters can be easily adjusted.

A model can be trained like this:

    python -m tgan_sr.train.gan --run-name NAME --params-file configs/CONFIG.json

During training, relevant metrics will be logged to `train_custom` in the run's directory and can be viewed with tensorboard afterwards.

A list of all configurations and names of JSON files:

* Standard WGAN: `wgan_gp10_nl6-4_nc2_bs1024.json`
* Standard GAN: `gan_nl6-4_nc2_bs1024.json`
* different added noise: add parameter "gan_sigma_real" and assign desired value
* WGAN on 10K-sized base dataset: `n10k_wgan_gp10_nl6-4_nc2_bs512.json`
* Sample data from the trained WGAN: `sample_n10k_wgan_gp10_nl6-4_nc2_bs512.json` (ensure the "load_from" field matches your trained run name)
* Classifier on default dataset: `class_nl4_bs1024.json` 
* Classifier on generated dataset: `class_Generated_nl4_bs1024.json` 
* WGAN with included classifier: `wgan+class_nl6-3s1_nc2_bs1024.json` 
* WGAN with absolute uncertainty objective: `wgan+class+uncert-abs_nl6-3s1_nc2_bs1024.json` (ensure the "looad_from" field matches your pre-trained name)
* WGAN with entropy uncertainty objective: `wgan+class+uncert-entr_nl6-3s1_nc2_bs1024.json` (ensure the "looad_from" field matches your pre-trained name)
* Sample data from the trained WGAN with entropy uncertainty objective: `sample_wgan+class+uncert-entr_nl6-3s1_nc2_bs1024.json` (ensure the "load_from" field matches your trained run name)


To test a trained classifier on an arbitrary dataset (validation):

    python -m tgan_sr.train.gan --run-name NAME --test --ds-name DATASET_NAME


