# Introduction


Here we construct the experimental results for the large QP benchmark in __Section 4__ of the paper. The working directory is `experiments/mega_test/` and the experiments are executed by
```
python mega_exp.py [data_name] [model1] [model2]... --nolarge/--onlylarge` 
```

+ `[data_name]` refers to the name of the problem set, including:
  + Maros-Meszaros test set: `mm`
  + Model predictive control test set: `mpc`
  + Random dense QP: `randomqp_dense`
  + Random sparse QP: `randomqp_sparse`
  + Projection onto the probability simplex: `random_projection`
  + Projection onto chain: `chain`

+  To run dQP with a specified forward [qpsolver](https://github.com/qpsolvers/qpsolvers), input `[model]` as `dQP_[solver]`, e.g. `dQP_gurobi`, `dQP_proxqp`. 

+ `--nolarge` is a flag used to only run problems with dimensions < 10k and `--onlylarge` is to only run problems with dimensions >= 10k. These two flags are used to test sets with large problems that cause OOM (out-of-memory) issue for other methods. It would kill the kernel so it might be more convenient to test with each flag separately. 

Random problems are generated by 
```
python create_random_data.py [data_name]
```




The testing results are stored in `experiments/mega_test/result/`. 

To get the figures, for each problem set, users need to concatenate all the results into one file named `[data_name].csv`, then run
```
python plot_result.py [data_name] --scatter/--time_accuracy
```
+ `--scatter` is a flag to plot the scatter plot of accuracy vs total time, where each dot represents a problem with its size illustrating the problem size. 

+ `--time_accuracy` is a flag to plot the total time and accuracy w.r.t to the problem size.

For experiments in this section, we modified the codes of `OptNet` and `SCQPTH`  to retrieve the dual solutions, which are stored at `deps/`

## Modularity and Performance
To test dQP with the leading forward solver for each problem in this set, input `[method]` as `dQP_best`.
### Model predictive control test set

```
python mega_exp.py mpc dQP_best QPLayer SCQPTH OptNet
```




### Maros-Meszaros test set 


```
python mega_exp.py mm dQP_best
```
Since OOM issue might frequently happen for other methods in this set, users are recommended to test each method seperately, and use the `--nolarge` `--large` flags or manually specify the problems to test to avoid this issue.


<!-- ```
python mega_exp.py mm QPLayer
```
```
python mega_exp.py mm SCQPTH
```
```
python mega_exp.py mm OptNet
``` -->


## Scalability
### Projection onto probability simplex
```
python create_random_data.py random_projection
```
```
python mega_exp.py random_projection dQP_gurobi QPLayer SCQPTH OptNet --nolarge
```
```
python mega_exp.py random_projection dQP_gurobi --onlylarge
```


### Projection onto chains
```
python create_random_data.py chain
```
```
python mega_exp.py chain dQP_gurobi QPLayer SCQPTH OptNet --nolarge
```
```
python mega_exp.py chain dQP_gurobi --onlylarge
```




