def create_timeseries_dataset(args, logger):
    
    if args.timefreq_transform == "stft":
        from data_utils.stft_data import STFTDataset
        dataclass = STFTDataset
    else:
        raise ValueError(
            f"Unsupported time-frequency transform: {args.timefreq_transform}. "
            "Supported transforms are: stft."
        )

    logger.info(f"Using {dataclass.__name__}")
    timeseries_data = dataclass(args, logger=logger)
    # (n_samples, seq_len, 3 or 1, n_freqs, n_features),  (n_samples, seq_len, n_covariates)
    timefreq_data, tmps_covariate = timeseries_data.get_data()
    logger.info(f"Shape of timefreq data: {timefreq_data.shape}")
    logger.info(f"Shape of time covariates: {tmps_covariate.shape}")

    return timeseries_data, timefreq_data, tmps_covariate
