import unittest
import doctest
import nn.deep_sets
import nn.flow
import nn.monotonic_net
import word_analogy.wv_wrapper


def load_tests(loader, tests, ignore):
    tests.addTests(doctest.DocTestSuite(nn.deep_sets))
    tests.addTests(doctest.DocTestSuite(nn.flow))
    tests.addTests(doctest.DocTestSuite(nn.monotonic_net, extraglobs={'mn': nn.monotonic_net.MonotonicNetwork()}))
    tests.addTests(doctest.DocTestSuite(word_analogy.wv_wrapper))
    return tests


if __name__ == "__main__":
    unittest.main()
