import time
import numpy
import torch


class Timer:
    def __init__(self):
        self.start = time.time()

    def stop(self):
        return time.time() - self.start


def normalize(vec, axis=0, epsilon=1e-12):
    norm = numpy.linalg.norm(vec, axis=axis, keepdims=True)
    return vec / numpy.maximum(norm, epsilon)


def get_device():
    return torch.device("cuda" if torch.cuda.is_available() else "cpu")
