# Sparse Dep Additive Model with Interaction: Enhancing Interpretability and Predictability (SDAMI)

The README.md is used to guide the unser to use the source code for replicating the numerical simulation in SDAMI, which is submitted to ICLR 2026.

In our work, we propose the SDAMI, a framework that combines sparsity-driven feature selection with deep subnetworks for flexible function approximation. Unlike conventional deep learning models, which often function as black boxes, SDAMI explicitly disentangles main effects and interaction effects to enhance interpretability. At the same time, its deep additive structure achieves higher predictive accuracy than classical additive models.

<!--
![](./imgs/DPS.png)
-->

## Dependency
You can install the Python dependencies with
```
pip3 install -r requirements.txt
```

## Reproducing numerical experiments
After unzip the SDAMI_ICLR.zip, the user can type following command to navigate to numerical experiments folder.

If you are running the experiment on slurm then 
```
>> cd ./src/script
>> bash run_SDAMI_train.sh
```
Please remember to revise the command in `.sh` file for different tasks.

For individual cases mentioned in the manuscipt, you can follow the command below to reproduce the results.
```
>> cd ./src
>> python3 main_glasso.py --data_name [case] --repeat [number of replication]
```

The argument for different cases are shown below

```
Note:
case 1: 'only_main'
case 2: 'weak_main'
case 3: 'inter_no_overlap'
case 4: 'inter_mild_overlap'
case 5: 'inter_strong_overlap'
case 6: 'only_inter'
```

The detailed formulation of each cases is given in section 5 on the manuscipt.

After the program is finished, the simulation results, selected feature from SDAMI, and information of the model will be stored as `{model_name}-{data_name}-n{training_data_size}.json`, `{model_name}-{data_name}-n{training_data_size}-feature.json`, and `{model_name}-{data_name}-n{training_data_size}.txt` under `.\src\output\`.
 
The summary of the model performance, TPR, and visualization can be found in `.\eval\MSE_TPR_FPR_Evaluation.ipynb`.

The data we use for simulation will be stored in `.\data\{data_name}-simulation_results.pt`. The dimension of the data is $(r,n,p)$ where $r$ is number of replication, $n$ is number of training datas, and $p$ is number of features. Thus, we can implement other sparse machine learning model as benchmark in our manuscript.

## Real Data Application
The real data analyses file can be found in ./experiments/ folder. The `Chip.ipynb, Diabetes.ipynb, V1Cell.ipynb` execute the corresponding Jupyter Notebook and demonstrate how SDAM works on these three datasets. 