from typing import ClassVar, overload

AVAILABLE_ULTRAMETRIC_TREE_TYPES: list
AVAILABLE_ULTRAMETRIC_TREE_TYPES_AS_STRINGS: list

BallTree: UltrametricTreeType
CoverTree: UltrametricTreeType
DCTree: UltrametricTreeType
HST: UltrametricTreeType
HilbertRTree: UltrametricTreeType
KDTree: UltrametricTreeType
LoadTree: UltrametricTreeType
MaxRPTree: UltrametricTreeType
MeanSplitBallTree: UltrametricTreeType
MeanSplitKDTree: UltrametricTreeType
RPTree: UltrametricTreeType
RPlusPlusTree: UltrametricTreeType
RPlusTree: UltrametricTreeType
RStarTree: UltrametricTreeType
RTree: UltrametricTreeType
UBTree: UltrametricTreeType
XTree: UltrametricTreeType

class UltrametricTreeType:
    __members__: ClassVar[dict] = ...  # read-only
    BallTree: ClassVar[UltrametricTreeType] = ...
    CoverTree: ClassVar[UltrametricTreeType] = ...
    DCTree: ClassVar[UltrametricTreeType] = ...
    HST: ClassVar[UltrametricTreeType] = ...
    HilbertRTree: ClassVar[UltrametricTreeType] = ...
    KDTree: ClassVar[UltrametricTreeType] = ...
    LoadTree: ClassVar[UltrametricTreeType] = ...
    MaxRPTree: ClassVar[UltrametricTreeType] = ...
    MeanSplitBallTree: ClassVar[UltrametricTreeType] = ...
    MeanSplitKDTree: ClassVar[UltrametricTreeType] = ...
    RPTree: ClassVar[UltrametricTreeType] = ...
    RPlusPlusTree: ClassVar[UltrametricTreeType] = ...
    RPlusTree: ClassVar[UltrametricTreeType] = ...
    RStarTree: ClassVar[UltrametricTreeType] = ...
    RTree: ClassVar[UltrametricTreeType] = ...
    UBTree: ClassVar[UltrametricTreeType] = ...
    XTree: ClassVar[UltrametricTreeType] = ...
    __entries: ClassVar[dict] = ...
    @overload
    def __init__(self, value: int) -> None: ...
    @overload
    def __init__(self, ultrametricTreeTypeString: str) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

def ultrametricTreeTypeToString(ultrametricTreeType: UltrametricTreeType) -> str: ...
def stringToUltrametricTreeType(ultrametricTreeTypeString: str) -> UltrametricTreeType: ...
