from typing import ClassVar, overload

AVAILABLE_PARTITIONING_METHODS: list
AVAILABLE_PARTITIONING_METHODS_AS_STRINGS: list

K: PartitioningMethod
Elbow: PartitioningMethod
Threshold: PartitioningMethod
ThresholdElbow: PartitioningMethod
QCoverage: PartitioningMethod
QCoverageElbow: PartitioningMethod
QStem: PartitioningMethod
QStemElbow: PartitioningMethod
LcaNoiseElbow: PartitioningMethod
LcaNoiseElbowNoTriangle: PartitioningMethod
MedianOfElbows: PartitioningMethod
MeanOfElbows: PartitioningMethod
Stability: PartitioningMethod
NormalizedStability: PartitioningMethod


class PartitioningMethod:
    __members__: ClassVar[dict] = ...  # read-only
    K: ClassVar[PartitioningMethod] = ...
    Elbow: ClassVar[PartitioningMethod] = ...
    Threshold: ClassVar[PartitioningMethod] = ...
    ThresholdElbow: ClassVar[PartitioningMethod] = ...
    QCoverage: ClassVar[PartitioningMethod] = ...
    QCoverageElbow: ClassVar[PartitioningMethod] = ...
    QStem: ClassVar[PartitioningMethod] = ...
    QStemElbow: ClassVar[PartitioningMethod] = ...
    LcaNoiseElbow: ClassVar[PartitioningMethod] = ...
    LcaNoiseElbowNoTriangle: ClassVar[PartitioningMethod] = ...
    MedianOfElbows: ClassVar[PartitioningMethod] = ...
    MeanOfElbows: ClassVar[PartitioningMethod] = ...
    Stability: ClassVar[PartitioningMethod] = ...
    NormalizedStability: ClassVar[PartitioningMethod] = ...
    __entries: ClassVar[dict] = ...
    @overload
    def __init__(self, value: int) -> None: ...
    @overload
    def __init__(self, partitioningMethodString: str) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

def partitioningMethodToString(partitioningMethod: PartitioningMethod) -> str: ...
def stringToPartitioningMethod(partitioningMethodString: str) -> PartitioningMethod: ...
