# Aranyani


This repository contains the implementation of the ICLR 2024 submission titled "Enhancing Group Fairness In Online Settings Using Oblique Decision Forests".


## Installation
The simplest way to run our implementation is to create with a new conda environment.
```
conda create -n arnya python=3.8
source activate arnya
pip install -r requirements.txt
```

## Running Aranyani

To run aranyani, use the following command:

```
cd src/
python main.py --dataset <name> --mode node --batch_size 1 --lambda_const 1.0
```

The dataset names used to run the above command is presented below:

```
{
  'Adult': 'adult',
  'Census': 'census',
  'COMPAS': 'compas',
  'CelebA': 'celeba',
  'CivilComments': 'jigsaw'
}
```

## Running Aranyani Using WandB

To get the exact accuracy-fairness tradeoffs reported in the paper you could use the exact configs and run a sweep over different hyperparameters using Weights & Biases. The wandb commands are shown below:

```
cd src/
wandb sweep -p <project_name> configs/<config_name>.yaml
```

After running the above command, wandb will generate a command with sweep id. You need to copy and paste that command. The output command will have the following format:

```
wandb agent <username>/<project_name>/<sweep_id>
```
