import argparse


def get_covi_config(args=None):
    parser = argparse.ArgumentParser(
        description="CoVi: Contrastive Vicinal Space for Unsupervised Domain Adaptation (ECCV-22)")
    parser.add_argument('-db_path', type=str, help="path to dataset repository")
    parser.add_argument('-source', type=str, default='amazon', help='source domain')
    parser.add_argument('-target', type=str, default='dslr', help='target domain')
    parser.add_argument('-workers', default=12, type=int, metavar='N', help="number of data loading workers")
    parser.add_argument('-gpu', help='gpu number', type=str, default='0')
    parser.add_argument('-batch_size', default=32, type=int)
    parser.add_argument('-baseline_path', type=str, help="path to pre-trainined model")
    parser.add_argument('-epochs', default=100, type=int, help="total training epochs")
    parser.add_argument('-cmin', type=float, default=0.1, help="EMP boundary:min")
    parser.add_argument('-cmax', type=float, default=0.9, help="EMP boundary:max")
    parser.add_argument('-swap_margin', type=float, default=0.1, help="margin for contrastive space")
    parser.add_argument('-swap_upper', type=float, default=0.9)
    parser.add_argument('-swap_lower', type=float, default=0.1)
    parser.add_argument('-swap_th', default=1.0, type=float, help="confidence threshold")
    parser.add_argument('-consensus_ratio', help='consensus_ratio', type=float, default=0.1)

    return parser.parse_args(args)
