import numpy as np

class Configurator:
    def __init__(self, num_obs):
        self.num_obs = num_obs

    def configure(self, sim_dict):
        batch_size = sim_dict["sim_data"].shape[0]
        summary_input = sim_dict["sim_data"]

        #summary_input = np.expand_dims(sim_dict["sim_data"], axis=1) #added
        summary_input = summary_input[:, :self.num_obs, :]


        out_dict = {
            "summary_conditions": summary_input.astype(np.float32),
            "parameters": sim_dict["prior_draws"].astype(np.float32),
        }

        return out_dict
