data {
    int N;
    int D;
    vector[D] y;
    vector[D] prior_mean;
    vector[D] prior_std;
    vector[D] y_std;
}

transformed data {
    matrix[D, D] Sigma_1;
    matrix[D, D] Sigma_2;
    Sigma_1 = diag_matrix(square(prior_std));
    Sigma_2 = diag_matrix(square(y_std));
}

parameters {
    vector[D] theta;
}

model {
  theta ~ multi_normal(prior_mean, Sigma_1);
  y ~ multi_normal(theta, Sigma_2);
}
