# Forecasting air passenger traffic: an autoregressive model with predictors

## 1. Instructions to run the experiment

1.   Run the file `stan.py` to get the results using the reference.
2. Run the file `trainer_npe.py` to train the model which utilises NPE based approach.
3. Run the file `trainer_sc.py` to train the model which utilises our NPE + SC based approach using the commands below - 

- `python trainer_sc.py --num_c 4 --output ./results/posterior_draws_sc_4c_32.npy`
- `python trainer_sc.py --num_c 8 --output ./results/posterior_draws_sc_8c_32.npy`
- `python trainer_sc.py --num_c 15 --output ./results/posterior_draws_sc_15c_32.npy`

4. For inference, run the files `plots.ipynb` to visualise the results of NPE and NPE + SC based approaches on the real dataset.

## 2. Dependencies

1. Create a conda environment using the file `requirements.txt`.
   

### Acknowledgement

The files in the directory `dataset` are taken from Eurostat and provided as per their redistribution policy (https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Copyright/licence_policy).

1. Eurostat. International extra-eu air passenger transport by reporting country and partner world regions and countries, doi:10.2908/avia_paexcc, 2022.
2. Eurostat. Household debt, consolidated including Non-profit institutions serving households - % of GDP, doi:10.2908/TIPSD22, 2022.
3. Eurostat. Real gdp per capita, doi:10.2908/SDG_08_10, 2022.
