data {
    int<lower=1> N;         // number of observations
    vector[N] y;            // observed response values
    vector[N] debt;         // predictor: debt
    vector[N] gdp;          // predictor: gdp
    vector[N] lag_y;        // lagged y (previous period's y)
}
parameters {
    real b0;                // intercept
    real bt;                // coefficient for lag_y
    real b1;                // coefficient for debt
    real b2;                // coefficient for gdp
    real logsigma;          // log standard deviation
}
transformed parameters {
    real sigma;
    sigma = exp(logsigma);
}
model {
    b0 ~ normal(0, 0.5);
    bt ~ normal(0, 0.2);
    b1 ~ normal(0, 0.5);
    b2 ~ normal(0, 0.5);
    logsigma ~ normal(-1, 0.5);

    for (i in 1:N) {
         y[i] ~ normal(b0 + bt * lag_y[i] + b1 * debt[i] + b2 * gdp[i], sigma);
    }
}
generated quantities {
   vector[N] y_pred;
   for (i in 1:N)
       y_pred[i] = normal_rng(b0 + bt * lag_y[i] + b1 * debt[i] + b2 * gdp[i], sigma);
}
