import numpy as np
import tensorflow as tf


# mean(abs(mean(y_pred) - y))
def mean_absolute_bias(trainer, y, n_samples=5000):
    posterior_draws = trainer.amortizer.sample(
        {"summary_conditions": y}, n_samples=n_samples
    )

    y_pred = trainer.generative_model.simulator(posterior_draws)["sim_data"]
    y_pred = tf.reshape(y_pred, [*posterior_draws.shape[:-1], 200]).numpy()

    absolute_bias_i = np.abs(np.mean(y_pred, axis=-2) - y)
    mean_absolute_bias = np.mean(absolute_bias_i, axis=-1)

    return mean_absolute_bias
