import numpy as np
from scipy.ndimage import gaussian_filter
from skimage.util import random_noise

def grayscale_camera(theta, psf_width=1.0):

    image2 = gaussian_filter(theta, sigma=psf_width)

    return image2


def configurator(f):
    out = {"likelihood_inputs": {}, "posterior_inputs": {}}
    
    B, H, W, C = f["prior_draws"].shape
    
    p = f["prior_draws"].reshape((B, H * W)).astype(np.float32)
    
    blurred = np.stack([grayscale_camera(f["sim_data"][b]) for b in range(B)]).astype(np.float32)

    # Set up likelihood inputs:
    out["likelihood_inputs"]["summary_conditions"] = p.reshape((B, H, W, 1))
    out["likelihood_inputs"]["parameters"] = blurred.reshape((B, H * W)) + 1e-5 * np.random.normal(size=(B, H * W))
    
    # Set up posterior inputs:
    out["posterior_inputs"]["parameters"] = p + 1e-5 * np.random.normal(size=p.shape)
    out["posterior_inputs"]["summary_conditions"] = blurred
    
    return out
