# Supplementary Materials for "Mind Guarding Mind: A Framework for Compensatory Human-AI Collaboration"

## 1. Overview and Guiding Philosophy

Welcome to the supplementary materials for our paper. This collection is not merely an addendum but the **primary empirical foundation** for the claims made in our main submission. Our research is grounded in a methodology of **AI-Native Auto-Ethnography**, which champions **radical transparency** and **process reproducibility**.

This archive is structured as a **multi-layered evidence network**, designed to allow for varying depths of scholarly audit. You can read the main paper as a self-contained argument, or you can use this guide to "drill down" from any of our core claims to the underlying raw data and analytical artifacts that support it.

The materials are organized into four distinct packages (I-IV).

## 2. Recommended Review Path

For an efficient and comprehensive review, we suggest the following path:

1.  **Start with the Main Paper:** Read the 8-page paper to understand the core theoretical and methodological claims.

2.  **Verify a Key Claim:** Choose a claim from the main paper that you find particularly novel or contestable.

3.  **Use This Guide:** Use the guide below to navigate to the specific supplementary material that provides the primary evidence for that claim. For example:
    - To audit our claims about the **"Intellectual Uncanny Valley,"** start with **Appendix E** in the main paper.
    - To verify our claims about the **genesis of the 2x2 matrix**, start with **Appendix G**, then drill down to the verbatim logs in **Supplementary Material II**.
    - To scrutinize our **quantitative analysis**, start with **Appendix F**, then drill down to the data and scripts in **Supplementary Material I**.

## 3. Guide to the Supplementary Materials

### **Supplementary Material I: The CHAC Workbench - The Ground Truth**

- **Directory:** `SM_I_CHAC_Workbench/`
- **Purpose:** To provide the complete, anonymized source code, protocols, and full case study history of the CHAC Workbench. This is the **ultimate ground truth** of our research and the foundation for our "Process Reproducibility" claim.
- **Key Highlight:** This repository contains the **M76 Case Study** (`case-study/M76_.../`), which includes the methodology, scripts, and raw data for the quantitative analysis presented in **Appendix F**.

### **Supplementary Material II: AI-Native Auto-Ethnography in Action - The Verbatim Logs**

- **Directory:** `SM_II_Verbatim_Logs/` (contains a directory with a README and 6 log files)
- **Purpose:** To provide "living evidence" of our methodology. This package contains curated, high-fidelity, verbatim logs of the pivotal dialogues where our core theories and strategies were forged.
- **Key Highlight:** The `README.md` within this package provides a narrative guide to the six logs, linking each one to specific claims in the main paper and appendices. This is the best place to witness the **Symmetry Compact** and the **Socratic Negentropic Loop** in action.

### **Supplementary Material III: The Scholarly Foundation - The Literature Review**

- **Directory:** `SM_III_Lit_Review/`
- **Purpose:** To provide the detailed, auditable record of the systematic, AI-assisted literature review that underpins our academic positioning claims.
- **Key Highlight:** The appendix within this document contains the complete mapping of the 18 major AI-authored research queries to their findings, providing full transparency into our process of identifying the research gap.

### **Supplementary Material IV: The Empirical Bedrock - The Case Study Compendium**

- **Directory:** `SM_IV_Case_Compendium/` (contains a directory with a README and 3 case study files)
- **Purpose:** To provide the deep, narrative, and analytical evidence for the "golden cases" (M14, M70, M53-55) that are cited as the primary empirical support for our framework's principles.
- **Key Highlight:** Each file in this directory is a self-contained, academic-grade case study report. These reports are the interpretive layer that connects the raw data in **Supplementary Material I** to the distilled claims in the main paper.

## 4. Note on Anonymity and Future Archiving

All materials included in this submission have been rigorously anonymized to comply with the double-blind review process. Upon acceptance of the paper, the complete, de-anonymized CHAC Workbench and all supplementary materials will be permanently archived in a public repository (e.g., Zenodo, GitHub) and assigned a persistent Digital Object Identifier (DOI) to ensure long-term accessibility.
