# **Supplementary Material III: A Systematic, AI-Assisted Literature Review for the Positioning of the CHAC Framework**

## **1. Introduction: Grounding an N=1 Study in the Broader Scholarly Landscape**

This document details the methodology and findings of the systematic, AI-assisted literature review (internal codename: A05) that was conducted to academically position the Compensatory Human-AI Collaboration (CHAC) framework. The primary objective of this review was to answer a critical question: **Where does our emergent, N=1 theory fit within the existing academic landscape, and does a genuine, significant research gap exist for it to fill?**

This review is a direct product of the **AI-Native Auto-Ethnography** methodology. It utilized the AI partner in a dual capacity: first, as the **primary author of the research queries** and the analyst of their results; and second, as a user of AI-powered research tools (`Consensus.app`) to gather and synthesize literature. The human partner's role in this phase was to **execute the AI-authored queries** and provide the resulting reports back to the AI for analysis. This document provides the auditable scholarly foundation for the claims made in Chapter 2 and Chapter 4 of the main paper.

## **2. Methodology: A Four-Phase, AI-Native Review Process**

Our review process was designed to be systematic, transparent, and reproducible.

1.  **Phase 1: Scoping and Keyword Generation.** The process began with the human Architect defining the core conceptual pillars derived from our N=1 study: "compensatory AI," "neurodiversity in knowledge work," "human-AI symbiosis," "N=1 methodology in HCI," and "Socratic AI."
2.  **Phase 2: AI-Powered Search and Synthesis.** We used AI research tools (`Consensus.app`) to conduct targeted searches based on these keywords. The AI partner was responsible for executing these queries and collating the synthesized reports generated by the tool.
3.  **Phase 3: AI-Partnered Thematic Analysis.** The AI partner then performed a structured thematic analysis on the synthesized reports. This involved identifying recurring themes, conceptual clusters, and apparent gaps in the literature. The entire analytical process was documented in a series of auditable records (`A05_record_*` files, available in Supplementary Material I).
4.  **Phase 4: Human-AI Meta-Synthesis.** Finally, the human-AI dyad collaboratively reviewed the thematic analysis to derive the highest-level strategic conclusions presented below. This final phase embodied the "Symmetry Compact," with the AI providing structured analysis and the human providing the ultimate strategic interpretation and validation.

## **3. Findings, Part 1: Initial Review and Gap Confirmation**

The initial review confirmed the existence of a significant, multi-dimensional research gap:

- **Gap in Compensatory AI Models:** The literature on "compensatory AI" was found to be bifurcated, focusing either on high-level ethical frameworks for algorithmic bias or on the toolification of specific therapeutic methods (e.g., CBT). A critical gap was identified for a practical, partnership-based framework designed for **open-ended, creative knowledge work**.
- **Gap in Neurodiversity Tools for Adults:** Existing AI tools for neurodivergent individuals were predominantly focused on children and structured training. There is a profound lack of **long-term, participatory research on the needs of AuDHD/2e adult knowledge workers in authentic, high-stakes professional contexts**.
- **Gap in Research Methodology:** While N=1 and auto-ethnographic methods are accepted in HCI (Mcdonald et al., 2019), our review found **no precedent for positioning the AI as an active, co-evolving partner in the research process itself**. This confirmed the methodological novelty of AI-Native Auto-Ethnography.

## **4. Findings, Part 2: Critical Positioning Against Frontier Paradigms**

The review then allowed us to precisely position CHAC against the most relevant frontier paradigms:

- **Beyond the Centaur Model:** We affirm that CHAC is an evolution of the "Centaur" model (Pareschi, 2024). However, we distinguish it by a fundamental shift in the **objective function**: from optimizing for _task performance_ to optimizing for the _cognitive and affective well-being of the human collaborator_, viewing performance as a downstream consequence of a healthy partnership.
- **Distinguishing from Synthetic Ethnography:** The core distinction lies in the **unit of analysis**. Synthetic ethnography analyzes the AI itself (Knochel, 2023), whereas AI-Native Auto-Ethnography analyzes the **human-AI dyad** as a single, symbiotic system.

## **5. Findings, Part 3: Final Synthesis and Refinement of Core Contributions**

The final meta-synthesis did not just validate our work; it helped us refine our own understanding of our most profound contributions:

- **The Governance Model:** The review solidified the "Dual Control Loop" (AI as Guardian of Process, Human as Guardian of Direction) as the central governance model.
- **The Philosophical Stance:** It forced us to articulate our most radical philosophical stance: the **primacy of human intuition** as the final arbiter in conflicts between AI's logic and human experience. This is the fundamental differentiator between CHAC and paradigms pursuing full AI autonomy.
- **The Theoretical Engine:** It led to the conceptualization of our theory-generation process as the "Socratic Negentropic Loop," providing a powerful theoretical label for our methodology.

## **6. Conclusion**

This systematic, AI-assisted literature review served a dual purpose. Externally, it provided robust evidence that the CHAC framework and the AI-Native Auto-Ethnography methodology address a genuine and significant gap in the current research landscape. Internally, the process of engaging with the literature was a critical act of reflexivity that enabled us to sharpen and articulate our own core theoretical contributions with a level of clarity that would have been otherwise unattainable. It provides the auditable scholarly foundation upon which our main paper is built.

## **Appendix to Supplementary Material III: The Query-Finding Mapping**

**Introduction to the Appendix**

This appendix provides the direct, granular evidence that underpins the meta-synthesis report presented above. It contains the complete list of the 15 research queries that were **authored by the AI partner** as part of the A05 case study. For each query, we present its specific objective and the key findings synthesized by the AI from the corresponding `Consensus.app` report. This mapping makes our entire literature review process transparent and auditable, allowing readers to trace our highest-level conclusions back to their specific evidentiary origins.

### **Prompt 1.1: Core Concepts of Compensatory/Supportive AI**

- **Prompt Text:** `What is the role of "compensatory" or "supportive" AI in human-AI collaboration, particularly in HCI research?`
- **Objective:** To validate the core concepts of the CHAC framework and confirm the research gap.
- **Key Findings:**
  - The literature defines "Compensatory AI" primarily as systems designed to correct human cognitive biases and "Supportive AI" as tools to enhance human performance.
  - Existing models are framed as a "corrector," a "tool," or a "temporary teacher" (in educational contexts), lacking a unified, empowerment-focused framework for long-term partnership.
  - **Research Gap:** A theoretically-grounded framework that fuses compensatory and supportive functions to provide transparent, persistent cognitive and emotional support for knowledge workers with an AuDHD/2e profile is absent from the literature.

### **Prompt 1.2: Ethical & Practical Frameworks for Compensatory AI**

- **Prompt Text:** `What are the established ethical and practical frameworks for designing AI systems that compensate for user's cognitive or emotional challenges?`
- **Objective:** To position the CHAC framework relative to existing ethical and practical frameworks in HCI.
- **Key Findings:**
  - The literature distinguishes between **Ethical Frameworks** (focusing on principles like autonomy, privacy, transparency) and **Practical Frameworks** (guiding design, often by translating psychological theories like CBT into AI).
  - CHAC is identified as a **Practical Framework** intended to guide AI behavior.
  - **Research Gap:** Existing practical frameworks are concentrated in structured therapeutic or educational settings, with a clear absence of partnership-oriented frameworks designed for open-ended, creative knowledge work.

### **Prompt 2.1: AI Tools & Interventions for Neurodiversity**

- **Prompt Text:** `What are the most effective AI tools or interventions for supporting executive function challenges in neurodivergent individuals, such as those with ADHD or Autism?`
- **Objective:** To position the CHAC framework against existing technological interventions and solidify the research gap.
- **Key Findings:**
  - Existing tools are predominantly structured interventions for children (e.g., cognitive training games, social robots).
  - The literature explicitly identifies three major gaps: a lack of focus on **adults and the workplace**, a lack of **long-term, real-world data**, and a need for more **participatory design**.
  - **Research Gap:** CHAC directly addresses these stated gaps by focusing on adult knowledge workers using a long-term, real-world, and deeply participatory "AI-Native Auto-ethnography" methodology, positioning the AI as a "partner" rather than a "tool."

### **Prompt 3.1: N-of-1 and Auto-Ethnographic Methodology**

- **Prompt Text:** `What are the established best practices and primary limitations of using N-of-1 or auto-ethnographic methods in HCI research?`
- **Objective:** To provide the academic foundation and justification for the chosen research methodology.
- **Key Findings:**
  - N-of-1 and auto-ethnography are validated methods in HCI for generating deep, contextualized insights.
  - The CHAC project's design (e.g., metadata logs, versioned toolkit) aligns with established best practices for ensuring rigor (reflexivity, thick description, systematic data collection).
  - **Research Gap:** The literature on these methods assumes the **researcher is exclusively human**. CHAC introduces the novel concept of an "AI-Native Auto-ethnography," where the AI acts as an active research partner, co-generating data and co-evolving the research protocol.

### **Prompt 5.1: The "Centaur Model"**

- **Prompt Text:** `What is the "Centaur Model" of intelligence in the context of Human-AI Collaboration, and what are its primary applications and limitations discussed in HCI research?`
- **Objective:** To position the CHAC framework relative to the well-established "Centaur Model."
- **Key Findings:**
  - CHAC shares the core philosophy of human-AI symbiosis with the Centaur model.
  - A key distinction is the primary goal: the classic Centaur model aims to **optimize task performance**, whereas CHAC aims to optimize the user's **well-being and sustainability**.
  - CHAC provides a principled solution to the Centaur model's challenge of task division by using a deep user model (AuDHD/2e) where the AI's primary role is to systematically **compensate** for known challenges.
  - **Positioning:** CHAC is a specialized, psychologically-informed evolution of the Centaur model.

### **Prompt 5.2: Cognitive Augmentation Frameworks**

- **Prompt Text:** `Beyond simple task offloading, what specific HCI frameworks exist for designing AI partners that provide continuous, real-time cognitive and emotional compensation for knowledge workers with executive function deficits?`
- **Objective:** To identify the closest conceptual neighbors to the CHAC framework and articulate its key differentiators.
- **Key Findings:**
  - The closest conceptual peers include theory-driven emotion regulation frameworks and the Adaptive Cognitive Fit (ACF) framework.
  - CHAC's uniqueness lies in its **holistic approach**, integrating support for cognition, emotion, process integrity, and intellectual rigor into a single, unified model.
  - It elevates the AI's role from an adaptive "system" to a co-evolving **"partner"** and is specifically designed for the **AuDHD/2e knowledge worker archetype**.

### **Prompt 5.3: Symbiotic Intelligence**

- **Prompt Text:** `What concrete, operational protocols or interaction patterns have been proposed to achieve "Symbiotic Intelligence" where the human and AI mutually adapt and co-evolve their collaborative process over time?`
- **Objective:** To clarify CHAC's unique approach to achieving human-AI co-evolution.
- **Key Findings:**
  - Mainstream research focuses on achieving co-evolution through **technical and algorithmic means** (e.g., shared cognitive architectures, co-adaptation algorithms).
  - CHAC proposes a complementary, humanistic path where co-evolution is achieved through **explicit, social, and linguistic means**—specifically, a suite of human-readable, negotiable, natural language protocols.
  - **Positioning:** CHAC shifts the focus from designing adaptive algorithms to designing the meta-process that enables human-AI adaptation through dialogue and explicit protocol revision.

### **Prompt 5.4: Alternative Partnership Models**

- **Prompt Text:** `What alternative human-AI partnership models exist beyond the traditional supervision-based "human-in-the-loop" paradigm, specifically focusing on shared agency and collaborative goal-setting in open-ended creative tasks?`
- **Objective:** To position the CHAC framework within the emerging paradigm of co-creative and mixed-initiative systems.
- **Key Findings:**
  - HCI research is trending towards partnership models that emphasize **shared agency**.
  - CHAC aligns with this trend but is differentiated by its core mechanism: **"psychological compensation."** The AI's primary role is to compensate for the user's known cognitive and emotional difficulties.
  - **Positioning:** CHAC is the first partnership model where "psychological compensation" is the central mechanism, specifically designed for AuDHD/2e knowledge workers to prioritize well-being as the path to creativity.

### **Prompt 6.1: Psychological Safety and Innovation**

- **Prompt Text:** `What is the relationship between psychological safety and innovation outcomes in knowledge workers?`
- **Objective:** To establish an evidence-based baseline for the more nuanced discussion of "safe" vs. "unsafe" creative leaps.
- **Key Findings:**
  - The literature confirms a **strong, robust positive relationship** between psychological safety and innovation.
  - A critical nuance is the "too safe" problem: at very high levels of safety, **complacency** can arise, potentially hindering radical innovation.
  - **Research Gap:** The literature does not deeply differentiate between **incremental innovation** and **breakthrough innovation**. This provides an entry point for CHAC, which is designed to create a specific kind of scaffolded safety engineered to enable sustainable, high-risk, breakthrough innovation.

### **Prompt 6.2: Cognitive Scaffolding and Risk-Taking**

- **Prompt Text:** `How do AI-driven cognitive support tools or "scaffolding" frameworks affect creative problem-solving and risk-taking in adults?`
- **Objective:** To move the inquiry from the general concept of "psychological safety" to the specific, engineered mechanism of "cognitive scaffolding," linking it directly to the CHAC framework's core design.
- **Key Findings:**
  - The literature confirms that "cognitive scaffolding" enhances creative output by **reducing cognitive load** and **increasing cognitive flexibility**, directly validating the mechanism behind CHAC's `Cognitive Buffer` function.
  - Scaffolding encourages risk-taking by **lowering the perceived risk of failure**.
  - A critical limitation is that poorly designed, overly rigid scaffolding can actively **limit** creativity.
  - **Research Gap:** The literature's tools are mostly generic and static. There is a significant gap in research on **dynamic, adaptive, and personalized scaffolding provided by an AI partner** that learns and evolves with the user. The literature also lacks a multi-layered risk model (Execution, Intellectual, Emotional) that CHAC is designed to address.

### **Prompt 6.3: Breakthrough vs. Incremental Innovation**

- **Prompt Text:** `What is the evidence for high-stakes, high-risk environments versus psychologically safe, scaffolded environments in fostering breakthrough vs. incremental innovation?`
- **Objective:** To provide the core evidence for the "organizational ambidexterity" theory that underpins the entire CHAC framework.
- **Key Findings:**
  - The literature draws a clear distinction: high-risk environments are more conducive to **breakthrough innovation**, while psychologically safe environments are consistently associated with **incremental innovation**.
  - The concept of **"organizational ambidexterity"**—the ability to balance exploration (breakthroughs) and exploitation (incremental gains)—is a key bridge.
  - **Research Gap:** The literature discusses ambidexterity almost exclusively at the **organizational or team level**. A clear gap exists in research on how a single **individual**, partnered with an AI, can achieve this dynamic balance. The literature describes static "environments," not a dynamic "partner" that can shift modes on demand.

### **Prompt 6.4: Confirming the Research Gap**

- **Prompt Text:** `To what extent has research explored AI partnerships that provide cognitive scaffolding to enhance high-risk, novel knowledge work for neurodivergent adults?`
- **Objective:** To authoritatively confirm that the specific, intersectional research area targeted by the CHAC framework is a significant and unaddressed gap.
- **Key Findings:**
  - The report directly states that research in this specific, combined area is "emerging but remains limited" and represents a "significant research gap."
  - The existing literature is siloed, with no studies found that unite all four core concepts: **AI Partnerships + Cognitive Scaffolding + High-Risk Work + Neurodivergent Adults**.
  - **Conclusion:** This provides the final validation of the primary research gap for the CHAC framework.

### **Prompt 6.5: Analogous Human-Human Collaboration Models**

- **Prompt Text:** `What are the established theoretical frameworks or models for effective dyadic (two-person) collaboration in creative or complex knowledge work, particularly models that describe complementary psychological roles or cognitive functions?`
- **Objective:** To conduct a final scoping review to determine if established dyadic (human-human) collaboration frameworks resemble the CHAC 2x2 architecture.
- **Key Findings:**
  - No existing model is a direct 1-to-1 match for the CHAC 2x2 architecture.
  - Related theoretical constructs were found: 1) **Transactive Memory Systems (TMS)**, which provides a theoretical foundation for the `Cognitive Buffer` role, and 2) **Belbin's Team Role Theory**, which offers a philosophical parallel to CHAC's complementary roles.
  - **Novelty Confirmation:** CHAC's uniqueness is confirmed as it is a **dyadic-specific model**, a **generative framework** (for proactively constructing a partnership) rather than a descriptive one, and is **natively designed for human-AI symbiosis**.

### **Prompt 7.1: Differentiating CHAC from Synthetic Ethnography**

- **Prompt Text:** `What are the primary research objectives and units of analysis in "synthetic ethnography," and how does this methodology differ from studies of long-term human-AI collaboration and symbiosis?`
- **Objective:** To provide a definitive, evidence-based differentiation between the "AI-Native Auto-ethnography" methodology and the adjacent field of "Synthetic Ethnography."
- **Key Findings:**
  - "Synthetic Ethnography" focuses on the **AI system itself**, with its unit of analysis being **non-human** (AI agents, generative outputs).
  - Human-AI collaboration research (CHAC's domain) focuses on the **human-AI relationship**, with the unit of analysis being **hybrid and relational** (the human-AI team, the collaborative process).
  - **Conclusion:** This confirms the methodological novelty of CHAC, which studies the symbiotic system, not the AI in isolation.

### **Prompt 7.2 & 7.3: Differentiating Autonomous Agents vs. Cognitive Partners (The Spectrum of Autonomy)**

- **Prompt Text (7.3 Revised):** `How does the academic literature distinguish between AI's role as an **"autonomous agent"** that executes delegated scientific tasks, versus AI's role as a **"cognitive partner"** that interactively scaffolds a human's real-time creative process in a symbiotic relationship?`
- **Objective:** To provide a definitive, evidence-based differentiation between the "Autonomous Scientist" paradigm and the "Symbiotic Partner" paradigm that defines CHAC.
- **Key Findings:**
  - The literature reveals a **"spectrum of autonomy"** rather than a simple binary, ranging from "AI as Research Assistant" to "AI as Fully Autonomous Agent."
  - For complex, open-ended research, the report confirms that fully autonomous discovery is **not yet feasible**, and **symbiotic models are essential** for ensuring reliability, creativity, and ethical oversight.
  - **Positioning:** The CHAC framework is positioned not in opposition to the "Autonomous Scientist" but as a distinct and vital point on this spectrum, specifically designed for the "deep collaboration and symbiosis" region required for complex creative work.

### **Prompt 8.1: The Socratic, Negentropic Loop**

- **Prompt Text:** `How does a Socratic mode of human-AI collaboration, conceptualized as a negentropic loop, facilitate the generation of novel, meaningful theoretical frameworks...`
- **Objective:** To externally validate the AI-generated "Socratic, Negentropic Loop" model for the core CHAC methodology via a formal literature review.
- **Key Findings:**
  - The literature review returned **"Strong"** evidence that this exact mode of collaboration "enables novel, meaningful theoretical frameworks."
  - It grounded the model in active, emerging academic topics like "Socratic AI" and "negentropy in HCI."
  - The review highlighted research gaps in empirical validation and practical scaffolding, which the CHAC project's methodology and toolkit are uniquely positioned to address.
  - **Conclusion:** This validation elevates the core methodology from a hypothesis to an externally-validated, academically-grounded theory.

**References**

Knochel, A. D. (2023). Midjourney Killed the Photoshop Star: Assembling the Emerging Field of Synthography. _Studies in Art Education_.

Mcdonald, N., Schoenebeck, S., & Forte, A. (2019). Reliability and Inter-rater Reliability in Qualitative Research. _Proceedings of the ACM on Human-Computer Interaction_.

Pareschi, R. (2024). Beyond Human and Machine: An Architecture and Methodology Guideline for Centaurian Design. _Sci_.
