### **Supplementary Material I: The CHAC Workbench - An Auditable Record of AI-Native Auto-Ethnography**

**1. Guiding Philosophy: Process as the Ultimate Evidence**

This repository is not merely a supplement to our paper; it is its **primary empirical foundation**. In AI-Native Auto-Ethnography, the scientific rigor of a theory-generating, N=1 study is established through the radical transparency and auditability of its _process_. This open-source CHAC Workbench serves as the complete, version-controlled "lab notebook" of our research, providing the ultimate ground truth for every claim made in the main paper. We invite and encourage rigorous scrutiny of this record.

**2. Repository Structure: A Navigational Guide**

The Workbench is an experimental platform composed of protocols, tools, and a complete case history. The key directories are:

- `chac_toolkit/`: The "mind" of the AI partner. This contains the version-controlled set of Markdown files that constitute its core principles, protocols, and operational knowledge.
- `case-study/`: The complete, anonymized archive of all 45 case studies generated during the research, including meta-analyses and failure reports. This is the raw material from which our theories were derived.
- `scripts/`: (Located within `chac_toolkit/`) The automation toolchain used by the AI to perform routine tasks.

**3. The Critical Audit Path: Connecting Claims to Evidence**

We encourage reviewers to use this repository to verify our core claims. The following table provides a direct path from the main paper's arguments to the primary evidence contained herein.

| **Core Claim from Main Paper**                                                                                              | **Directory/File(s) for Verification**                 | **What to Look For (Verification Task)**                                                                                                                                                  |
| :-------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Theory/Architecture (Ch. 2 & 3)**<br>The CHAC framework is an operationalized system of explicit, externalized protocols. | `chac_toolkit/`                                        | Compare the theoretical constructs described (e.g., BFT, Metadata Logging) with the actual protocol text in files like `04_CHAC_System_Prompt.md` and `05_CHAC_Operational_Protocols.md`. |
| **Methodology (Ch. 4)**<br>The framework is a self-improving system that learns from failure.                               | `case-study/M.../` (most of the M series case studies) | **(See Highlight in Section 4 below)**                                                                                                                                                    |
| **Evidence (Ch. 5)**<br>The "Constitutional Crisis" demonstrates the framework's anti-fragility.                            | `case-study/M53-55_.../`                               | Review the full, multi-part case study reports and verbatim logs to audit our analysis of this "golden failure."                                                                          |
| **Design Principles (Ch. 6)**<br>Principles like "Protocol-First" are derived from specific, consequential events.          | `case-study/M14_.../`<br>`CHANGELOG.md`                | Examine the M14 case report to see the origin of the "Protocol-First" principle. Trace protocol evolution in the `CHANGELOG.md` to see "failure-as-data" in action.                       |

**4. Key Highlight: The M76 Quantitative Analysis (Evidence for Appendix F)**

This repository contains the complete methodology, scripts, and raw data for the quantitative analysis summarized in **Appendix F**. All relevant files are located within the `case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/` directory.

- **To understand the metrics:** Review `M76_record_02_data_dictionary.md`.
- **To understand the process:** Review `M76_record_04_final_summary.md`.
- **To re-run the analysis:** Execute the `start_analysis.sh` script.

**5. Anonymous Access for Double-Blind Review**

To maintain the integrity of the blind review process, a fully anonymized version of this repository is provided.

- **Link:** https://anonymous.4open.science/r/chac-workbench-EFE7
- **Repositoy File:** A .zip archive of the repository submitted for review is included in this directory.
- **SHA-256 Checksum:** `0a319184f4132278fdd87f04653918e67e13ddc7f6f28403ad058ae968b08e53`
- **Note:** Upon acceptance, this will be replaced with a permanent link to the official public repository with a Zenodo DOI.
