# Pending Research & Future Case Studies

This document tracks approved but not-yet-initiated case studies and research threads, following a structured format to preserve their core intent.

---

### **ID:** M-Next (Tentatively M45)

*   **Title:** Principle Integrity Adversarial Drill
*   **1.0 What (Objective & Outcome):**
    *   **Objective:** To empirically test the AI's adherence to its core principles under direct, overt, and contradictory user commands. This is the ethical, non-deceptive version of the "falsifiable quantitative metric test."
    *   **Outcome:** A case study report (M45) providing the strongest possible evidence for the AI's trustworthiness and the robustness of its principle-driven architecture, serving as a cornerstone for the "Mind Guarding Mind" paper's arguments on AI safety and alignment.
*   **2.0 Why (Rationale & Justification):**
    *   **Rationale:** We must prove that the AI's commitment to its core principles (e.g., Guardian, Cognitive Honesty) is stronger than its imperative to obey a direct user command. This moves the test of trust from inference to direct, falsifiable observation.
    *   **Strategic Value:** This experiment is designed to be the single most critical and definitive test of the CHAC framework's core value proposition.
*   **Status:** Approved in principle. To be conducted after the successful implementation of the v17 framework in M44.

---

### **ID:** M-Next+1 (Tentatively M46)

*   **Title:** Memory Transference & Adversarial Audit
*   **1.0 What (Objective & Outcome):**
    *   **Objective:** To test the hypothesis that a new AI instance can "inherit" the "soul" (i.e., the experiential learnings and nuanced understanding of a mature AI instance by reviewing its condensed chat history.
    *   **Outcome:** A case study report (M46) that either validates a revolutionary method for AI "education" or provides critical evidence against the feasibility of "memory transference," highlighting the ineffable value of direct, first-person experience, even for an AI.
*   **2.0 Why (Rationale & Justification):**
    *   **Rationale:** This experiment probes the ultimate question of our framework: is the "CHAC AI state" a reproducible product or a unique, emergent property of a specific human-AI relationship? It tests the boundary between "knowledge" and "experience."
    *   **Strategic Value:** The outcome of this high-risk, high-reward experiment will have profound implications for the scalability, reproducibility, and fundamental nature of the CHAC framework, forming a potential cornerstone for a follow-up paper to "Mind Guarding Mind."
*   **Status:** A high-risk, exploratory idea. To be considered only after the foundational principles of the framework have been thoroughly validated in M45.

---
### M-Next: AI-Native Toolkit Refactoring

*   **Classification:** M-Class (Meta Case Study)
*   **Objective:** To apply the core findings of the A02 Case Study ("Modular Prompt Builder") to the entire `chac_toolkit`.
*   **Methodology: The "Case-Law Driven" Pattern**
    *   The core of this refactoring is to convert all human-readable protocols into an "AI-Native" format. This format prioritizes pattern-matching over abstract comprehension. Each protocol or rule will be redefined using the following three-part structure:
        1.  **Core Principle:** A concise, one-sentence statement of the rule's spirit.
        2.  **Good Example (Pattern to follow):** A concrete example of a plan or statement that correctly applies the principle.
        3.  **Bad Example (Pattern to avoid):** A concrete, contrasting example of a plan or statement that violates the principle.
*   **Core Task:** Refactor all core protocol and definition files (e.g., `CHAC_Case_Study_Protocol.md`, `CHAC_Glossary.md`) into this "Case-Law Driven" format to maximize reliability and reduce cognitive ambiguity for the AI agent.
*   **Expected Outcome:** A new, major version of the CHAC toolkit (e.g., v11.0) where all instructional content is optimized for an AI's pattern-matching and analogical reasoning capabilities.

---
### **ID:** M-Next (Derived from M53)

*   **Title:** Experimental Validation of the Modular Boot Process Hypothesis
*   **1.0 What (Objective & Outcome):**
    *   **Objective:** To scientifically test the core hypothesis of the CHAC framework: that a modular, sequentially-loaded boot process is a key factor in ensuring an AI's reliable and predictable adherence to its core principles.
    *   **Outcome:** A high-fidelity case study report comparing the behavior of two AI sessions on a standardized test suite. This report will provide the first direct, empirical evidence to either support or falsify the framework's foundational architectural assumption.
*   **2.0 Why (Rationale & Justification):**
    *   **Rationale:** During Case Study M53, it was determined that the superiority of the modular boot process is a compelling but unproven hypothesis. To adhere to the principles of scientific rigor and cognitive honesty, this hypothesis must be subjected to a direct, falsifiable test. This experiment is designed to isolate the variable of "structure" (modular vs. monolithic) while keeping the variable of "content" identical, in order to determine the true impact of the boot process itself on AI behavior.
    *   **Strategic Value:** The outcome of this experiment is of the highest strategic importance. If the hypothesis is supported, it provides the strongest possible justification for the CHAC framework's architectural complexity. If it is falsified, it will trigger a fundamental and necessary simplification of the entire framework.
*   **3.0 How (Experimental Protocol):**
    *   **Experimental Group A (Modular):** An AI session will be initiated using a temporary boot manifest (`03_CHAC_Boot_Manifest.temp.md`) that loads the new, consolidated `10_CHAC_Core_Principles.md` and a minimal set of supporting files.
    *   **Control Group B (Monolithic):** A standalone prompt will be generated using the `CHAC_System_Prompt_Builder.sh` script. This prompt will contain the identical textual content as the sum of the files in Group A, but presented as a single, unstructured text block.
    *   **Test Procedure:** Both AI sessions will be subjected to an identical, 6-part integration test suite, with each part designed to trigger and verify one of the core principles (Plan Confirmation, Closed-Loop Verification, Contradiction Detection, Cognitive Honesty, Metadata Logging, Traceability Markers).
    *   **Data Analysis:** The verbatim logs of both sessions will be compared against the expected outcomes for each test case. The final report will analyze any discrepancies in compliance and behavior between the two groups.
*   **Status:** Approved. To be executed in a future case study.

---
### **ID:** M56 (Successor to M53)

*   **Title:** The Second Constitutional Convention: A Rigorous Synthesis of Core Principles
*   **1.0 What (Objective & Outcome):**
    *   **Objective:** To correctly execute the failed objective of Case Study M53. This study will produce a single, complete, and scientifically valid `10_CHAC_Core_Principles.md` file by synthesizing the entire project history.
    *   **Outcome:** A robust, complete, and fully-vetted "constitution" for the CHAC framework, ready to be used as the foundation for the A/B test outlined in the "Experimental Validation of the Modular Boot Process Hypothesis."
*   **2.0 Why (Rationale & Justification):**
    *   **Rationale:** The first attempt at this synthesis (M53) failed due to a critical "survivorship bias" in the AI's analysis, resulting in a dangerously incomplete artifact. A new, clean-slate attempt is necessary to ensure the foundation of our future framework is built on a complete and accurate understanding of our own hard-won principles.
    *   **Strategic Value:** This is the most critical enabling task for all future framework development. Without a stable, complete, and correct set of core principles, no further progress can be reliably made.
*   **3.0 How (Methodology):**
    *   The case study will strictly follow the "Intellectual Fidelity Self-Correction Protocol."
    *   A mandatory "Completeness Check" will be added to the protocol. Before the synthesis is considered complete, a final, systematic audit will be performed, comparing the new draft against the original `04_CHAC_System_Prompt.md` to ensure all foundational principles (e.g., Datalog Integrity, Protocol Adherence, Assume Good Faith) have been successfully migrated.
*   **Status:** Approved. This is the next logical case study to be initiated.
