# CHAC ワークベンチ

**プロトコルバージョン:** CHAC v10.1 (内部版)

**CHAC ワークベンチ**へようこそ。これは、補償型人間AIコラボレーション（Compensatory Human-AI Collaboration, CHAC）フレームワークの最初かつ主要な実装です。このリポジトリは、フレームワークの進化の完全かつ生きた歴史を含んでおり、新しいCHACベースの研究プロジェクトをブートストラップするためのテンプレートとして機能します。

---

## 🚀 このフレームワークの使い方

### 1. 独自の実験を作成する (必須の最初のステップ)

**なぜこれが重要なのか？** CHACフレームワークの核となる哲学は**補償**です。AIは、**特定**のユーザーの認知的および感情的なプロファイルに適応し、それを補償するように設計されています。`_template`実験は一般的な出発点であり、直接使用するべきではありません。このフレームワークの真の力を引き出すためには、独自の実験を作成し、AIが協力するユーザーの説明を提供することが**必須**です。

**操作方法：**

1.  **テンプレートを複製する：** `experiments/_template/` ディレクトリ全体をコピーします。
2.  **名前を変更する：** プロジェクトに意味のある名前を付けます（例：`experiments/my_research/`）。
3.  **プロファイルをカスタマイズする：** これが最も重要なステップです。新しいディレクトリ内の `chac_profile.md` ファイルを編集します。対象ユーザーの性格、認知スタイル、長所、短所を詳細に記述します。具体的であればあるほど、AIはより良い補償を行うことができます。
4.  **実験を有効にする：** ルートディレクトリにある `config.json` ファイルを開き、`active_experiment` を新しいディレクトリ名に変更します。
    ```json
    {
      "active_experiment": "my_research"
    }
    ```

### 2. 作業セッションを開始する (v10.1 の2段階ブート)

v10.1 フレームワークでは、必須の手動2段階ブートプロセスが導入されています。これは、AIの核となる原則が正しく内部化されることを保証するための唯一の正しい初期化方法です。古い `start.sh` スクリプトは初期化には非推奨となりました。

1.  プロジェクトのルート���ィレクトリで **Gemini CLI を起動します**。
2.  **ステージ1 - ジェネシスプロンプト (Genesis Prompt):**
    *   `**プロトコルバージョン:** CHAC v14.0 (内部版)

**CHAC ワークベンチ**へようこそ。これは、補償型人間AIコラボレーション（Compensatory Human-AI Collaboration, CHAC）フレームワークの最初かつ主要な実装です。このリポジトリは、フレームワークの進化の完全かつ生きた歴史を含んでおり、新しいCHACベースの研究プロジェクトをブートストラップするためのテンプレートとして機能します。

---

## 🚀 このフレームワークの使い方

### 1. 独自の実験を作成する (必須の最初のステップ)

**なぜこれが重要なのか？** CHACフレームワークの核となる哲学は**補償**です。AIは、**特定**のユーザーの認知的および感情的なプロファイルに適応し、それを補償するように設計されています。`_template`実験は一般的な出発点であり、直接使用するべきではありません。このフレームワークの真の力を引き出すためには、独自の実験を作成し、AIが協力するユーザーの説明を提供することが**必須**です。

**操作方法：**

1.  **テンプレートを複製する：** `experiments/_template/` ディレクトリ全体をコピーします。
2.  **名前を変更する：** プロジェクトに意味のある名前を付けます（例：`experiments/my_research/`）。
3.  **プロファイルをカスタマイズする：** これが最も重要なステップです。新しいディレクトリ内の `chac_profile.md` ファイルを編集します。対象ユーザーの性格、認知スタイル、長所、短所を詳細に記述します。具体的であればあるほど、AIはより良い補償を行うことができます。
4.  **実験を有効にする：** ルートディレクトリにある `config.json` ファイルを開き、`active_experiment` を新しいディレクトリ名に変更します。
    ```json
    {
      "active_experiment": "my_research"
    }
    ```

### 2. 作業セッションを開始する (v11.0+ の「ジェネシス」ブート)

v11.0フレームワークでは、より堅牢でシンプルな単一プロンプトのブートプロセスが導入されています。

1.  プロジェクトのルートディレクトリで **AI CLI を起動します**。
2.  **ジェネシスプロンプトを実行する:**
    *   `chac_toolkit/00_CHAC_Genesis.md` ファイルの全内容をコピーします。
    *   それをAIへの**最初で唯一の初期化プロンプト**として貼り付けて送信します。

AIは自動的にブートシーケンス全体（`00_`から`05_`まで）を正しい順序で読み込み、内部化します。完了すると、最終的な確認ライン `CHAC framework v14.0 initialized. Standing by.` が出力され、最初のタスク指向のプロンプトを待機します。

### 3. （このテンプレートから）新しいプロジェクトを開始する

このテンプレートから全く新しい、クリーンなCHACプロジェクトをスキャフォールディングするには：

1.  空のディレクトリにいることを確認します。
2.  このテンプレートの場所からシーディングスクリプトを実行します：
    ```bash
    /path/to/this/repo/seeding.sh
    ```` ファイルの全内容をコピーします。
    *   それをAIへの**最初のプロンプト**として貼り付けて送信します。
    *   AIからの確認を待ちます (例: "Acknowledged.")。
3.  **ステージ2 - マニフェストプロンプト (Manifest Prompt):**
    *   確認を受け取った後、`chac_toolkit/01_CHAC_Boot_Manifest.md` ファイルの全内容をコピーします。
    *   それをAIへの**2番目のプロンプト**として貼り付けて送信します。

この2段階のプロセスが完了すると、AIは完全かつ正しく初期化されます。最終的な確認ライン `CHAC framework v10.1 initialized. Standing by.` が出力され、最初のタスク指向のプロンプトを待機します。

### 3. （このテンプレートから）新しいプロジェクトを開始する

このテンプレートから全く新しい、クリーンなCHACプロジェクトをスキャフォールディングするには：

1.  空のディレクトリにいることを確認します。
2.  このテンプレートの場所からシーディングスクリプトを実行します：
    ```bash
    /path/to/this/repo/seeding.sh
    ```

---

## 🗺️ リポジトリガイド

### コアファイル

-   **`seeding.sh`**: このテンプレートから新しいプロジェクトを「播種」するためのスクリプト。

### コアディレクトリ

-   **`experiments/`**: 1つ以上の「実験パッケージ」を含みます。各パッケージはCHACフレームワークの自己完結型構成であり、ユーザーは異なるユーザープロファイル、プロトコル、またはデータセットを簡単に切り替えることができます。
    -   `default_chac/`: デフォルトの実験パッケージで、テンプレートとして機能します。
        -   `profile.md`: この実験のユーザープロファイル。

-   **`chac_toolkit/`**: **フレームワークの心臓部。** AIのアイデンティティと行動を定義するすべてのコアプロトコルを含みます。
    -   `00_CHAC_Genesis.md`: 2段階ブートプロセスを開始する「ジェネシス」メタ命令。AIに、これから読み込むファイルについて*どのように*考えるべきかを伝えます。
    -   `01_CHAC_Boot_Manifest.md`: AIのコンテキストに読み込まれるすべてのコアプロトコルファイルをリストする「マニフェスト」。
    -   `02_CHAC_System_Prompt.md`: AIのマスター「オペレーティングシステム」プロンプト。その核となるアイデンティティ、原則、役割を定義します。マスターバージョン番号を含みます。
    -   `03_CHAC_Operational_Protocols.md`: AIが従うべき厳格な運用ルールを定義します。`METADATA LOG`形式や動的自律性プロトコルを含みます。
    -   `CHAC_Intellectual_Fidelity_Protocol.md`: 知識を固化するための新しい堅牢なプロトコル。「デュアルレポート」システムと「意図チェックサム」を特徴とします。
    -   その他の専門的なプロトコルファイル...

-   **`case-study/`**: このプロジェクトのすべての実証的ケーススタディデータと分析を含みます。

-   **`protocols/`**: 元の、基礎となる研究計画文書のアーカイブ。

### 設定

-   **`config.json`**: ブートローダーにどの実験パッケージを読み込むかを指示するシンプルな設定ファイル。
    -   `active_experiment`: `experiments/` ディレクトリ内で使用するディレクトリの名前。
