# The CHAC Workbench

**Protocol Version:** CHAC v14.0 (Internal)

Welcome to the **CHAC Workbench**, the first and primary implementation of the Compensatory Human-AI Collaboration (CHAC) framework. This repository contains the complete, living history of the framework's evolution and serves as a template for bootstrapping new CHAC-based research projects.

---

## 🚀 How to Use This Framework

### 1. Creating Your Own Experiment (Required First Step)

**Why is this important?** The core philosophy of the CHAC framework is **compensation**. The AI is designed to adapt to and compensate for a *specific* user's cognitive and emotional profile. To unlock the true power of this framework, you **must** create your own experiment and provide the AI with a description of the user it is meant to collaborate with.

**How to do it:**

1.  **Duplicate the template:** Copy the entire `experiments/_template/` directory.
2.  **Rename it:** Give it a meaningful name for your project, e.g., `experiments/my_research/`.
3.  **Customize your profile:** This is the most critical step. Follow the `chac_toolkit/CHAC_Profile_Co-Creation_Protocol.md` to collaboratively generate a high-fidelity `profile.md` file inside your new directory.
4.  **Activate your experiment:** Open the `config.json` file in the root directory and change the `active_experiment` to point to your new directory name.

### 2. Starting a Work Session (The v11.0 "Genesis" Boot)

The v11.0 framework introduces a robust, single-prompt boot process that is both simpler and more reliable.

1.  **Launch your AI CLI** in the project's root directory.
2.  **Execute the Genesis Prompt:**
    *   Copy the entire content of the file `chac_toolkit/00_CHAC_Genesis.md`.
    *   Paste it as your **first and only initialization prompt** to the AI and send.

The AI will now automatically read and internalize the entire boot sequence (`00_` to `05_`) in the correct order. Upon completion, it will output a final confirmation line: `CHAC framework v10.1 initialized. Standing by.` and will then await your first task-oriented prompt.

---

## 🗺️ Repository Guide

### Core Directories

-   **`experiments/`**: Contains one or more "experiment packages." Each package is a self-contained configuration for the CHAC framework.
-   **`chac_toolkit/`**: **The heart of the framework.** Contains all the core protocols that define the AI's identity and behavior. See the `chac_toolkit/README.md` for a detailed breakdown of the boot sequence and all protocol files.
-   **`case-study/`**: Contains all empirical case study data and analysis for this project.
-   **`build/`**: Contains the output of the `CHAC_SOP_Modular_Prompt_Builder.md` process, such as standalone prompts.

### Configuration

-   **`config.json`**: A simple configuration file that tells the framework which experiment package to load.
    -   `active_experiment`: The name of the directory in `experiments/` to use.