# CHAC 工作台

**协议版本:** CHAC v10.1 (内部版)

欢迎来到 **CHAC 工作台**，这是“补偿性人机协作”（Compensatory Human-AI Collaboration, CHAC）框架的第一个、也是最主要的实现。本代码仓库包含了该框架演进的完整、鲜活的历史，并可作为一个模板，用于引导和启动新的、基于CHAC的研究项目。

---

## 🚀 如何使用此框架

### 1. 创建您自己的实验 (必需的第一步)

**为何这很重要？** CHAC框架的核心哲学是**补偿**。AI被设计为去适应并补偿一个**特定**用户的认知与情感特征。`_template`实验是一个通用的起点，不应被直接使用。为了释放此框架的真正力量，您**必须**创建您自己的实验，并向AI提供它需要协作的用户的详细描述。

**如何操作：**

1.  **复制模板：** 复制整个 `experiments/_template/` 目录。
2.  **重命名：** 为您的项目给它一个有意义的名字，例如 `experiments/my_research/`。
3.  **定制您的画像：** 这是最关键的一步。编辑您新目录下的 `chac_profile.md` 文件。详细描述目标用户的性格、认知风格、优势和劣势。您描述得越具体，AI就能更好地进行补偿。
4.  **激活您的实验：** 打开根目录下的 `config.json` 文件，并将 `active_experiment` 的值更改为您的新目录名。
    ```json
    {
      "active_experiment": "my_research"
    }
    ```

### 2. 开始一个工作会话 (v10.1 的两阶段启动)

v10.1 框架引入了一个强制性的、手动的、两阶段的启动过程。这是唯一正确初始化AI，以确保其核心原则被正确内化的方法。旧的 `start.sh` 脚本已被弃用。

1.  在项目的根目录下**启动 Gemini CLI**。
2.  **阶段一 - 创世提示 (Genesis Prompt):**
    *   **协议版本:** CHAC v14.0 (内部版)

欢迎来到 **CHAC 工作台**，这是“补偿性人机协作”（Compensatory Human-AI Collaboration, CHAC）框架的第一个、也是最主要的实现。本代码仓库包含了该框架演进的完整、鲜活的历史，并可作为一个模板，用于引导和启动新的、基于CHAC的研究项目。

---

## 🚀 如何使用此框架

### 1. 创建您自己的实验 (必需的第一步)

**为何这很重要？** CHAC框架的核心哲学是**补偿**。AI被设计为去适应并补偿一个**特定**用户的认知与情感特征。`_template`实验是一个通用的起点，不应被直接使用。为了释放此框架的真正力量，您**必须**创建您自己的实验，并向AI提供它需要协作的用户的详细描述。

**如何操作：**

1.  **复制模板：** 复制整个 `experiments/_template/` 目录。
2.  **重命名：** 为您的项目给它一个有意义的名字，例如 `experiments/my_research/`。
3.  **定制您的画像：** 这是最关键的一步。编辑您新目录下的 `chac_profile.md` 文件。详细描述目标用户的性格、认知风格、优势和劣势。您描述得越具体，AI就能更好地进行补偿。
4.  **激活您的实验：** 打开根目录下的 `config.json` 文件，并将 `active_experiment` 的值更改为您的新目录名。
    ```json
    {
      "active_experiment": "my_research"
    }
    ```

### 2. 开始一个工作会话 (v11.0+ 的“创世”启动)

v11.0 框架引入了一个更健壮、更简单的单提示启动过程。

1.  在项目的根目录下**启动 AI CLI**。
2.  **执行创世提示:**
    *   复制 `chac_toolkit/00_CHAC_Genesis.md` 文件的全部内容。
    *   将其作为您的**第一个也是唯一的初始化提示**粘贴并发送。

AI 将会自动按正确顺序读取并内化整个启动序列（`00_` 到 `05_`）。完成后，它将输出最终确认行：`CHAC framework v14.0 initialized. Standing by.`，然后等待您的第一个面向任务的提示。

### 3. （从此模板）开始一个新项目

要从此模板搭建一个全新的、干净的CHAC项目：

1.  确保您处于一个空目录中。
2.  从此模板的位置运行 seeding 脚本：
    ```bash
    /path/to/this/repo/seeding.sh
    ```
    *   将其作为您的**第一个提示**粘贴到AI中并发送。
    *   等待AI的确认 (例如, "Acknowledged.")。
3.  **阶段二 - 舱单提示 (Manifest Prompt):**
    *   在收到确认后，复制 `chac_toolkit/01_CHAC_Boot_Manifest.md` 文件的全部内容。
    *   将其作为您的**第二个提示**粘贴到AI中并发送。

完成这个两阶段过程后，AI将被完全并正确地初始化。它将输出一行最终确认信息：`CHAC framework v10.1 initialized. Standing by.`，然后等待您的第一个面向任务的提示。

### 3. （从此模板）开始一个新项目

要从此模���搭建一个全新的、干净的CHAC项目：

1.  确保您处于一个空目录中。
2.  从此模板的位置运行 seeding 脚本：
    ```bash
    /path/to/this/repo/seeding.sh
    ```

---

## 🗺️ 代码仓库指南

### 核心文件

-   **`seeding.sh`**: 用于从此模板“播种”一个新项目的脚本。

### 核心目录

-   **`experiments/`**: 包含一个或多个“实验包”。每个包都是CHAC框架的一个自包含配置，允许用户轻松地在不同的用户画像、协议或数据集之间切换。
    -   `default_chac/`: 默认的实验包，可作为模板。
        -   `profile.md`: 此实验的用户画像。

-   **`chac_toolkit/`**: **框架的心脏。** 包含所有定义AI身份和行为的核心协议。
    -   `00_CHAC_Genesis.md`: “创世”元指令，启动两阶段引导过程，告诉AI*如何*思考它即将加载的文件。
    -   `01_CHAC_Boot_Manifest.md`: “舱单”，列出了所有需要被加载到AI上下文中的核心协议文件。
    -   `02_CHAC_System_Prompt.md`: AI的主“操作系统”提示，定义了其核心身份、原则和角色。包含主版本号。
    -   `03_CHAC_Operational_Protocols.md`: 定义了AI必须遵循的严格操作规则，包括`METADATA LOG`格式和动态自主协议。
    -   `CHAC_Intellectual_Fidelity_Protocol.md`: 用于知识固化的、新的、健壮的协议，以“双报告”系统和“意图校验码”为特色。
    -   以及其他专门的协议文件...

-   **`case-study/`**: 包含此项目的所有实证案例研究数据和分析。

-   **`protocols/`**: 用于存放原始的、奠基性的研究计划文档的存档。

### 配置

-   **`config.json`**: 一个简单的配置文件，告诉引导程序应该加载哪个实验包。
    -   `active_experiment`: `experiments/` 目录下要使用的目录名。
