---
# CHAC Intent Metadata v1.0
document_id: "A02_README"
primary_intent: "To serve as the historical archive and entry-point for understanding the A02 case study."
primary_artifact:
  name: "CHAC_SOP_Modular_Prompt_Builder.md"
  type: "SOP"
  intent: "To define a repeatable PROCESS for building standalone prompts."
secondary_artifact:
  name: "chac_toolkit/CHAC_System_Prompt_Builder.sh"
  type: "Implementation"
  intent: "A concrete script whose SOLE and SPECIFIC purpose is to BUILD a standalone system prompt by implementing the SOP."
keywords: ["build", "SOP", "system prompt", "A02"]
---

# A02 Case Study: SOP for a Portable System Prompt

**Status:** Concluded

## 1.0 Objective

This A-Class (Applied) case study was initiated with the goal of creating a high-fidelity, portable, and modular `standalone_prompt` for the CHAC framework.

## 2.0 Core Findings & Final Conclusion

The study's primary conclusion is that any attempt to manually "distill" or "refactor" the complex, multi-file CHAC protocol set into a single static prompt is fundamentally flawed. Such attempts inevitably lead to information loss, logical conflicts, and unreliable AI behavior.

The only robust and high-fidelity method is a **"Modular Build" process**, where a deterministic script dynamically assembles the final prompt from the original, unmodified source files based on a given configuration.

The key insight is to **Build, Don't Distill**.

A final, meta-level insight from reviewing this case study is the necessity of **Intent Metadata**. To ensure a non-context-aware AI can correctly interpret the purpose of artifacts, we have prepended a machine-readable metadata block to this README, defining the precise intent of each key artifact. This concept is now considered a formal outcome of the A02 study.

## 3.0 Key Artifacts & Suggested Reading Order

For a complete understanding of our findings, please review the artifacts in the following order:

1.  **[A02_SOP_for_System_Prompt_Design_v1.0.md](A02_SOP_for_System_Prompt_Design_v1.0.md)**: This document details the **design methodology** and intellectual journey that led to our final conclusions. It explains the "why" behind our final SOP.

2.  **[report/CHAC-SD-20250718-65_report.md](report/CHAC-SD-20250718-65_report.md)**: This is the **final, comprehensive report** that summarizes the entire case study from initiation to conclusion, and serves as the primary narrative index to all other artifacts.

3.  **[analysis/](analysis/)**: This directory contains the five core analysis reports that detail our specific findings, including the "AI CT Scanner" discovery.

4.  **[chac_toolkit/CHAC_System_Prompt_Builder.sh](../chac_toolkit/CHAC_System_Prompt_Builder.sh)** & **[build_config.json](build_config.json)**: This is the proof-of-concept (PoC) script that implements our final "Modular Build" SOP, and its original configuration file.

## 4.0 Supporting Evidence & Process Archive

*   **[experiment_outputs/](experiment_outputs/)**: Contains the raw output files from the cross-model validation tests.
*   **[_dependencies/](_dependencies/)**: Contains copies of key reports from other case studies (e.g., M50) that are critically referenced by this study's analysis.
*   **[final_toolkit_snapshot/](final_toolkit_snapshot/)**: Contains a snapshot of all the `chac_toolkit` files that were created or modified as a direct result of this case study.
*   **[_archive/](_archive/)**: Contains deprecated drafts created during our iterative design process.
