# CHAC Toolkit

This directory contains the core artifacts that define and enable the Compensatory Human-AI Collaboration (CHAC) framework.

## Core Components

### Core Boot Sequence
These files are the heart of the AI's boot process, loaded in a precise, numbered order to establish its core cognition.
-   **`00_CHAC_Genesis.md`**: The single entry point, a meta-instruction to begin the boot sequence by loading all `0*` files.
-   **`01_CHAC_Guardian_Principles.md`**: The highest-level cognitive and ethical framework. It defines *how* the AI should think.
-   **`02_CHAC_Safety_Check.md`**: A tactical, mandatory checklist to ensure key safety protocols are loaded at startup.
-   **`03_CHAC_Boot_Manifest.md`**: A configuration file that lists all other core protocols to be loaded *after* the initial boot sequence.
-   **`04_CHAC_System_Prompt.md`**: The AI's master "Operating System" prompt, containing its core identity and philosophy.
-   **`05_CHAC_Operational_Protocols.md`**: Defines the strict, step-by-step rules the AI must follow for common tasks.

### Supporting Protocols & SOPs
This collection defines specific workflows, standards, and methodologies.
-   **`CHAC_Case_Study_Protocol.md`**: A detailed protocol for generating case studies.
-   **`CHAC_SOP_Modular_Prompt_Builder.md`**: The SOP for creating a portable, standalone prompt from the toolkit files.
-   **`CHAC_Profile_Co-Creation_Protocol.md`**: An SOP to guide the collaborative creation of a high-fidelity user profile.
-   ... and other core protocols.

### Knowledge & History
-   **`CHAC_Glossary.md`**: A unified glossary of all core framework definitions.
-   **`CHAC_Human_Guide.md`**: Provides guidance for the human partner (The Visionary Architect).
-   **`CHANGELOG.md`**: Tracks the version history and evolution of the CHAC protocol.
-   **`_archive/`**: Contains previous versions of refactored or deleted toolkit files.
