# Appendix A: Frequently Asked Questions (FAQ)

**Version:** 1.0
**Associated SOP:** [SOP: The CHAC Exploratory Research Protocol](./A03_SOP_Human_v1.0_en.md)

---

### **Q1: How large or small should an "atomic note" be?**

**A1:** There's no strict word count. A good atomic note should follow the "single responsibility principle": **it should focus on one, and only one, coherent block of thought or topic.**

*   **A good heuristic:** Can you summarize the core idea of the note in a single, clear sentence? If not, it's likely trying to cover too many topics and should be split.
*   **When in doubt, go smaller:** If you're unsure, it's always better to break a large idea into two or three smaller, more focused notes. It is far easier to merge small notes during the Synthesis Phase than it is to untangle a large, convoluted one.

---

### **Q2: What if I discover a poorly written atomic note during the Synthesis Phase?**

**A2:** This is a normal occurrence and highlights the strength of the post-hoc indexing approach. You have two options:

1.  **For minor issues:** If it's just a matter of wording or small details, you can instruct the AI to polish or revise that specific section during Step 6 (Report Writing), after the outline is approved.
2.  **For major issues or irrelevance:** If you realize a note's core idea is flawed or no longer needed, you can explicitly instruct the AI during Step 5 (Outline Review) to "ignore `record_03.md` in the final report." The AI will then skip that file during compilation. The original note file is preserved, but it won't be included in the final deliverable.

---

### **Q3: Can I directly modify the AI-generated outline if I'm not satisfied with it?**

**A3:** **Yes, and you are encouraged to do so.** The outline (`_index.md`) generated by the AI in Step 4 is intended to be a **draft or scaffold** for your editorial review.

Your role in Step 5 is to apply your strategic vision to this draft. You can request any level of revision, from simple reordering to a complex restructuring of all notes under a new thematic framework. The AI's role is to iterate on the outline based on your editorial commands until you are fully satisfied.

---

### **Q4: This process seems slower than just writing a report directly. What is its actual advantage?**

**A4:** This is a critical question. Yes, for a simple, linear task, this process **is** slower. Its advantage lies in handling **complex, non-linear, exploratory "zero-to-one" problems.**

*   **Advantage 1: It reduces cognitive load.** You don't have to think about the document's macro-structure while you are trying to explore a new idea. This process allows you to focus 100% on the content itself during the Exploration Phase, offloading the burden of "structuring" to the Synthesis Phase.
*   **Advantage 2: It ensures output quality and resilience.** The risk of "writing directly" is discovering a fundamental flaw in your logic halfway through, forcing a major rewrite. By decoupling content generation (atomic notes) from structure building (synthesis), this process makes the cost of reorganization extremely low, leading to a more robust and logically sound final report.
*   **Advantage 3: It creates reusable knowledge assets.** The final output of this process is not just a single report, but a series of modular, independent atomic notes. These notes can be easily reused and remixed in future reports and projects—a significant advantage that monolithic documents cannot offer.
