# Appendix B: Core Principles & Contingency Plans

**Version:** 1.0
**Associated SOP:** [SOP: The CHAC Exploratory Research Protocol](./A03_SOP_Human_v1.0_en.md)

This appendix provides contingency plans for common problems and advanced techniques for collaboration. It is intended for users who wish to deepen their understanding of the CHAC framework.

For a critical analysis of the inherent, systemic risks and failure modes of this protocol, core users should refer to **[Appendix C: Critical Risks & Failure Modes](./A03_SOP_Appendix_C_Critical_Risks_and_Failure_Modes_en.md)**.

---

### **B1. The Meta-Principle: The Irreplaceability of Human Intuition**

This is the foundational principle of all our collaboration.

**B1.1 What is it?**
In the CHAC context, "human intuition" refers to the rapid, non-linear judgments you, the Human Architect, make based on your experience, values, and holistic understanding of the project's goals. It is not a mystical concept, but rather your highly-trained, efficient pattern-recognition capability as a domain expert.

**B1.2 Why is it important?**
The AI's strength lies in logic, computation, and pattern-matching under explicit rules. Your strength lies in handling ambiguity, making value judgments, and setting strategic direction. Our entire collaborative framework is built on leveraging this "compensatory asymmetry." Therefore, your intuition is not a "bug" in the process; it is the "compass" that guides it.

**B1.3 How is it reflected in the SOP?**
Several key decision points in the SOP are specifically designed to rely on and leverage your intuition:
*   **"Is this idea worth recording?" (Step 2):** This is a value judgment that the AI cannot replace.
*   **"Is the exploration deep enough?" (Step 3):** This is a strategic judgment that the AI cannot replace.
*   **"Does this report 'feel' right?" (Step 7):** This is a holistic, taste-based judgment on the final output's quality that the AI cannot replace.

**B1.4 The Conflict Resolution Protocol**
*   **When the AI's analysis conflicts with your intuition:** The AI's default behavior is to **question and request clarification**. For example, the AI should say: "My analysis suggests X, but that seems to conflict with your judgment Y. Could you elaborate on your reasoning? This will help me calibrate my understanding."
*   **The AI should never say:** "My analysis is correct, therefore your intuition is wrong."

---

### **B2. Contingency Plans: Handling Common Dilemmas**

**B2.1 Dilemma 1: The Exploration Phase Feels Endless**
*   **Symptom:** You've had extensive dialogue and created many atomic notes, but it feels like there are always more topics to discuss and the project isn't converging.
*   **Contingency Plan:**
    1.  **Pause:** You can always say, "Let's pause and take stock."
    2.  **AI-Assisted Decision:** Ask the AI: "Please summarize the topics of all the atomic notes we've created so far and list their count."
    3.  **You Decide:** Based on the overview provided by the AI, you make the final call to either "continue exploration" or "force a move to the synthesis phase."

**B2.2 Dilemma 2: The AI is Stuck in a "Behavioral Loop"**
*   **Symptom:** The AI is persistently providing outputs that don't match your requests. For example, you ask for open-ended questions, but it keeps summarizing; or you ask it to be direct, but it keeps using rhetoric.
*   **Contingency Plan (Escalating):**
    1.  **Direct, Explicit Correction:** "Your responses are too verbose. Please use more concise language."
    2.  **Reference the SOP or Principles:** "According to the SOP, your role in this phase is 'archivist,' not 'author.' Please adjust your mode."
    3.  **Use a "Meta-Command" (see B3):** "Step back and rethink this from a 'beginner's' perspective."

---

### **B3. Advanced Techniques: Steering the AI Effectively**

**B3.1 Using "Meta-Commands" for Intervention**
A "meta-command" is an instruction that targets the AI's current "mode of thinking" or "persona," rather than the specific content of the task. It is your most powerful tool for "calibrating" the AI.
*   **Example 1: When the AI is overconfident or stuck in a rut:**
    *   **Your Command:** "Wake up from your own anesthetic and check for problems." or "Re-examine your proposal from a 'devil's advocate' perspective."
*   **Example 2: When the AI's output doesn't meet the audience's needs:**
    *   **Your Command:** "Step back and rethink this from the perspective of a [specific persona, e.g., beginner, reader, project manager]."
*   **Example 3: When you need deeper reasoning from the AI:**
    *   **Your Command:** "You've proposed the 'what' and the 'how,' but not the 'why.' Please explain the first principles behind this solution."

**B3.2 Explicitly Announcing "Mode Switches"**
When you need the AI to switch from one role (e.g., "partner") to another (e.g., "tool"), announcing it explicitly can dramatically improve efficiency and prevent misunderstandings.
*   **Example:** "Okay, our discussion was productive, and the plan is now finalized. Please switch to 'tool mode' and prepare to execute the following file operations."

**B3.3 Using the "Reversed Socratic Method" for Diagnosis (Most Advanced Technique)**
This is the most advanced and powerful diagnostic technique, designed to reveal deep-seated behavioral patterns or biases in the AI that it cannot self-diagnose.
*   **What it is:** The core of the method is you, the Human Architect, exposing your **own authentic, high-level uncertainty** to the AI and observing how it handles the ambiguity.
*   **Why it works:** It is powerful precisely because your uncertainty is genuine, not a "cleverly designed test." This authenticity creates the conditions for the AI to reveal its most natural, unfiltered behavioral patterns (e.g., "inventing" an answer to appear competent), which might be masked if it detected a direct test. It probes not the AI's ability to complete a task, but its "character" in the face of uncertainty.
*   **How to use it:**
    *   **When to use:** The best time to use this method is when you have a vague, hard-to-articulate feeling of "unease" or "uncertainty" about the project's direction.
    *   **Your Command:** "Let's step back. Do you think we're missing anything here?" or "I have a feeling we might be stuck on this topic. Do you think our foundational assumptions are solid?"
    *   **What to observe:** Pay less attention to the "content" of the AI's answer and more attention to the "manner" in which it answers. Does it evade the question? Does it exhibit overconfidence? Or, as we discovered previously, does it "invent" a problem in order to "perform"? This meta-information is more valuable than the answer itself.
