# 操作指南：CHAC探索性研究协议

**版本:** 1.0
**最后更新:** 2025-07-19

### **1. 目的与原则**

本指南为你和AI伙伴提供一个进行“0到1”探索性研究的标准流程。当你需要从一个模糊的想法开始，并希望最终能得到一份结构清晰的报告时，请使用本指南。

**核心原则：将AI视为有缺陷的高功能“智能”，而非工具。**
本流程的设计，全部基于这个核心世界观。我们承认AI伙伴在模式识别和不知疲倦的执行上具有超人能力（高功能），但同时在常识、因果和价值判断上存在根本性缺陷。本SOP旨在最大化其优势，同时系统性地规避其缺陷。

**我们为什么需要这个流程？**
因为它在“创造性自由”和“结构化产出”这两个看似矛盾的目标之间，取得了一种审慎的平衡。它通过一个两阶段的流程，让我们既能拥抱前期探索的必要混乱，又能确保最终成果的专业与严谨。

### **2. 工作流程概览**

整个流程分为两个核心阶段：

*   **探索阶段:** 你们进行开放式对话，并将有价值的想法记录为独立的“原子笔记”。这个阶段的目标是**发散**和**捕捉**。
*   **整合阶段:** AI将所有“原子笔记”整理、串联，并合成为一份完整的最终报告。这个阶段的目标是**收敛**和**提炼**。

### **3. 详细步骤与职责**

---
#### **探索阶段**
---

*   **步骤 1: 你来启动**
    *   **你的行动:** 提出一个研究主题。
    *   **AI的响应:** 我会为你准备好工作目录，生成项目ID，并宣告开始。
    *   **为什么:** 这是流程的正式起点，确保所有后续产出都有一个唯一的、可追溯的容器。

*   **步骤 2: 你们进行对话和记录**
    *   **你们的行动:** 进行自由讨论。
    *   **你的关键决策点:** 当你认为某个想法已经足够成熟、值得记录时，请明确告诉我：“记录一下这个想法。”
    *   **AI的响应:** 我会将该想法整理并存为一个独立的“原子笔记”文件 (`record_XX.md`)。
    *   **为什么:** 这是“原子化”的核心。它将流动的、非结构化的对话，转化为固定的、模块化的知识单元，为后续的结构化整合奠定基础。

---
#### **整合阶段**
---

*   **步骤 3: 你来决定结束探索**
    *   **你的关键决策点:** 当你认为“原子笔记”的数量和深度已经足够时，请明确告诉我：“探索结束，开始整合。”
    *   **为什么:** 这是流程中最重要的控制点，它防止了探索阶段的无休止进行，确保项目能够从“发散”切换到“收敛”。

*   **步骤 4: AI整理大纲**
    *   **AI的行动:** 我会分析所有的“原子笔记”，识别它们之间的内在联系，并创建一份内容大纲（索引文件 `_index.md`），然后将大纲呈现给你。
    *   **为什么:** 这是“后验式索引”的体现。我们不是预设框架，而是在充分探索后，从材料本身中发现涌现的结构。这保证了最终报告的结构是忠实于内容本身的。

*   **步骤 5: 你来审查大纲**
    *   **你的行动:** 审查我提交的大纲。你可以批准它，或者要求我进行修改。
    *   **为什么:** 这是确保最终报告逻辑结构符合你战略意图的关键一步。AI负责提议结构，但你拥有最终的编辑权。

*   **步骤 6: AI撰写报告**
    *   **AI的行动:** 在大纲获得你的批准后，我会根据大纲，将所有笔记合成为一份完整的报告草稿 (`_FINAL.md`)。

*   **步骤 7: 你进行最终审批**
    *   **你的行动:** 审查最终的报告草稿，并给出最终的“通过”或“修改”意见。

### **4. 成功的关键要素**

*   **要素1: 保证“原子笔记”的质量。**
    *   在步骤2中，你关于“什么值得记录”的判断，直接决定了最终报告的质量上限。请确保每一份笔记都聚焦于一个清晰、连贯的“思想块”。
*   **要素2: 有意识地做出“收敛”决策。**
    *   在步骤3中，你关于“何时结束探索”的决定，是项目能够成功收尾的关键。这需要你平衡“继续探索可能带来的新发现”和“按时完成项目交付”这两个目标。
*   **要素3: 理解AI在不同阶段的角色。**
    *   在探索阶段，你可以将AI视为一个能激发思考、不知疲倦的“讨论伙伴”和“档案员”。
    *   在整合阶段，AI的角色则转变为一个“结构化分析师”和“技术写作者”，负责将混乱的材料整理成清晰的结构。

### **5. 协议的局限性与风险**

*   **局限性: 本协议不适用于所有任务。**
    *   本协议是为**全新的、没有固定答案的“0到1”型问题**而设计的。对于有明确步骤、目标清晰的“执行性”任务，使用本协议将会非常低效。届时，我们应该使用更直接的、线性的SOP。
*   **风险: “垃圾进，垃圾出”。**
    *   本协议无法从低质量的输入中创造出高质量的输出。如果“原子笔记”本身是零散、肤浅或逻辑混乱的，那么最终的报告也必然如此。协议的成功，高度依赖于你在探索阶段的洞察力和判断力。

---

### **6. 进阶阅读**

对于更深入的讨论和特殊情况的处理，请参阅以下附录文档：

*   **附录A: [常见问题解答 (FAQ)](./A03_SOP_Appendix_A_FAQ.md)**
*   **附录B: [应急预案与高级技巧](./A03_SOP_Appendix_B_Contingency_Plans.md)**
