# SOP: The CHAC Exploratory Research Protocol

**Version:** 1.0
**Last Updated:** 2025-07-19

### **1. Purpose and Principles**

This document provides a standard operating procedure (SOP) for conducting "zero-to-one" exploratory research with an AI partner. Use this guide when you need to start from a vague idea and progressively develop it into a well-structured report.

**The First Principle: Treat the AI as a Flawed, High-Functioning Intellect, not a Tool.**
This entire process is designed around this core worldview. We acknowledge that the AI partner has superhuman capabilities in pattern recognition and tireless execution (high-functioning), yet possesses fundamental deficits in common sense, causality, and value judgments (flawed). This SOP is engineered to maximize its strengths while systematically mitigating its weaknesses.

**Why does this process exist?**
It's designed to strike a deliberate balance between two conflicting goals: creative freedom and structured output. By separating the workflow into two distinct phases, it allows for the necessary chaos of early-stage exploration while ensuring the final deliverables are professional and rigorous.

### **2. Workflow Overview**

The process is divided into two core phases:

*   **Phase 1: Exploration:** You and your AI partner engage in open-ended dialogue, capturing valuable insights as discrete "atomic notes." The goal of this phase is **divergence** and **capture**.
*   **Phase 2: Synthesis:** The AI partner organizes and connects all atomic notes, compiling them into a coherent final report. The goal of this phase is **convergence** and **distillation**.

### **3. Detailed Steps and Responsibilities**

---
#### **Phase 1: Exploration**
---

*   **Step 1: You Initiate**
    *   **Your Action:** Propose a research topic.
    *   **AI's Response:** I will prepare the workspace, generate a project ID, and formally begin the process.
    *   **The Rationale:** This marks the formal start of the process, ensuring all subsequent artifacts are contained and traceable.

*   **Step 2: You and the AI Dialogue and Record**
    *   **Your Action:** Engage in free-form discussion with the AI.
    *   **Your Key Decision:** When you believe an idea is mature enough to be recorded, give the explicit command: "Let's record this idea."
    *   **AI's Response:** I will summarize the idea and save it as a new, separate "atomic note" file (`record_XX.md`).
    *   **The Rationale:** This is the core of "atomization." It converts fluid, unstructured conversation into fixed, modular units of knowledge, which is essential for the structured synthesis later.

---
#### **Phase 2: Synthesis**
---

*   **Step 3: You Conclude the Exploration**
    *   **Your Key Decision:** When you judge that the quantity and depth of the atomic notes are sufficient, give the explicit command: "Exploration phase is over. Let's begin synthesis."
    *   **The Rationale:** This is the most critical control point in the process. It prevents endless exploration and formally shifts the project from divergence to convergence.

*   **Step 4: The AI Drafts an Outline**
    *   **AI's Action:** I will analyze all atomic notes, identify the emergent connections between them, and create a content outline (as an `_index.md` file), which I will then present to you.
    *   **The Rationale:** This is "post-hoc indexing" in action. We don't start with a preconceived framework; we discover the emergent structure from the material itself. This ensures the final report's structure is faithful to the content.

*   **Step 5: You Review the Outline**
    *   **Your Action:** Review the outline I submit. You can approve it or request revisions.
    *   **The Rationale:** This step is crucial for ensuring the final report's logical structure aligns with your strategic intent. The AI proposes a structure, but you have the final editorial authority.

*   **Step 6: The AI Writes the Report**
    *   **AI's Action:** Once you approve the outline, I will synthesize the contents of all atomic notes into a complete draft report (`_FINAL.md`).

*   **Step 7: You Give Final Approval**
    *   **Your Action:** Review the final draft report and give the final "approve" or "revise" command.

### **4. Keys to Success**

*   **Factor 1: Ensure the Quality of Atomic Notes.**
    *   Your judgment in Step 2 about what is "worth recording" directly determines the quality ceiling of the final report. Ensure each note focuses on a single, coherent block of thought.
*   **Factor 2: Make a Conscious Decision to Converge.**
    *   Your decision in Step 3 is key to successfully completing the project. This requires you to balance the potential for new discoveries from further exploration against the goal of delivering a finished product on time.
*   **Factor 3: Understand the AI's Role in Each Phase.**
    *   In the Exploration Phase, treat the AI as a thought partner and archivist, useful for brainstorming and capturing ideas.
    *   In the Synthesis Phase, the AI's role shifts to that of a structural analyst and technical writer, responsible for organizing raw material into a coherent structure.

### **5. Protocol Limitations and Risks**

*   **Limitation: This protocol is not for all tasks.**
    *   This SOP is designed specifically for novel, "zero-to-one" problems without a clear, predefined answer. It will be inefficient for well-defined, "execution-style" tasks, for which a more direct, linear SOP should be used.
*   **Risk: "Garbage In, Garbage Out."**
    *   This process cannot create a high-quality output from low-quality inputs. If the atomic notes themselves are shallow, scattered, or logically inconsistent, the final report will be as well. The protocol's success is highly dependent on your insight and judgment during the Exploration Phase.

---

### **6. Further Reading**

For more in-depth discussions and for handling special cases, please refer to the following appendices:

*   **Appendix A: [Frequently Asked Questions (FAQ)](./A03_SOP_Appendix_A_FAQ_en.md)**
*   **Appendix B: [Core Principles & Contingency Plans](./A03_SOP_Appendix_B_Core_Principles_and_Contingency_Plans_en.md)**
