**Parent Case:** CHAC-SD-N2ZiMWEy-20250810
**Topic:** Core Feature Design for CHAC-Lite Prototype

## 1.0 Objective

To define the initial, minimum viable feature set for the "CHAC-Lite" prototype. The design prioritizes simplicity and direct alignment with the core challenges of the AuDHD/2e user archetype, ensuring the prototype is both easy to use and immediately valuable.

## 2.0 Guiding Principles for Feature Selection

*   **Simplicity:** The prototype must avoid overwhelming the user. Each feature must be maximally simple and focused on a single, clear purpose.
*   **Direct Compensation:** Each feature must directly map to a known pain point for AuDHD/2e users (e.g., task initiation, cognitive overwhelm, emotional avoidance).
*   **Embodying CHAC:** The features, while simple, must embody the core CHAC philosophy of acting as an external cognitive and emotional support system.

## 3.0 Core Feature Set (Version 1.0)

The initial version of the CHAC-Lite prototype will contain the following three features:

### 3.1 Feature 1: "Today's Intention"
*   **Pain Point Addressed:** Difficulty with task initiation and a lack of clear daily direction.
*   **Functional Description:**
    *   Upon opening the app, the user is greeted with a single, non-judgmental input field.
    *   The guiding prompt is: "What is one feeling or piece of progress you'd like to have by the end of today?"
    *   The user is encouraged to define a high-level, emotional or value-based goal (e.g., "a sense of control," "relief from a nagging task") rather than a specific to-do list item.
    *   This intention is then displayed prominently at the top of the interface for the remainder of the session, acting as a "compass" for all subsequent actions.

### 3.2 Feature 2: "The Task Decomposer"
*   **Pain Point Addressed:** Cognitive overwhelm and procrastination when facing large, ambiguous tasks.
*   **Functional Description:**
    *   The user inputs a large, intimidating task (e.g., "Finish the quarterly report").
    *   The application guides the user through a short, structured, Socratic dialogue to identify the immediate next step.
        *   *Prompt 1:* "What is the very first physical action required to start this?" (e.g., "Open the file").
        *   *Prompt 2:* "What tool or file do you need for that action?" (e.g., "The file is at `/path/to/report.docx`").
        *   *Prompt 3:* "How much time, realistically, will that single action take?" (e.g., "5 minutes").
    *   The feature's output is not a full project plan, but a single, concrete, and achievable **"Next Action"**.

### 3.3 Feature 3: "Fears & Excitements"
*   **Pain Point Addressed:** Emotional avoidance, anxiety, and lack of motivation, often linked to perfectionism or imposter syndrome.
*   **Functional Description:**
    *   After defining a "Next Action" with the Task Decomposer, the user is presented with two simple, optional text boxes.
    *   **Fears Prompt:** "What's a worst-case, anxious thought you have about this task?" (e.g., "My boss will think my work is sloppy.").
    *   **Excitements Prompt:** "What's the best-case feeling or outcome you're looking forward to after this task?" (e.g., "Finally getting this off my plate and enjoying my evening.").
    *   **Purpose:** This is not a problem-solving tool, but an emotional externalization exercise. The goal is to make vague, internal anxieties concrete and visible, thereby reducing their power to unconsciously drive avoidance.

## 4.0 Next Steps

This feature set will be presented to volunteers for feedback on its clarity, relevance, and potential effectiveness. Based on their input, this design may be refined before development begins.