**Parent Case:** CHAC-SD-NTE2NzA4-20250810
**Topic:** Literature Review Findings for Prompt 1.2 - Ethical & Practical Frameworks

## 1.0 Objective

To document the analysis of the literature review report generated by Consensus.app in response to Prompt 1.2. This record helps to precisely position the CHAC framework relative to existing ethical and practical frameworks in HCI.

**Prompt 1.2:** `What are the established ethical and practical frameworks for designing AI systems that compensate for user's cognitive or emotional challenges?`

## 2.0 Key Findings from Literature

The report clearly distinguishes between two types of frameworks for compensatory AI, primarily applied in sensitive domains like mental health and education.

### 2.1 Theme A: Ethical Frameworks
*   **Focus:** Establishing high-level principles and "guardrails" to ensure AI systems are safe and respect users.
*   **Core Principles:** User Autonomy, Privacy, Transparency, Fairness, and the necessity of Human Oversight.
*   **Purpose:** To prevent harm and misuse.

### 2.2 Theme B: Practical Frameworks
*   **Focus:** Guiding the concrete design and implementation of supportive AI systems.
*   **Core Methods:** Adaptive Personalization, Explainability, and the integration of established psychological theories (e.g., Cognitive Behavioral Therapy - CBT, Social-Emotional Learning - SEL).
*   **Purpose:** To create effective, user-centered applications, often by translating specific therapeutic modalities into an AI context.

## 3.0 Analysis of the Research Gap

This body of work provides a perfect backdrop to highlight the uniqueness of the CHAC framework.

### 3.1 Confirmation Signals
1.  **CHAC as a Practical Framework:** The report's distinction clarifies that CHAC is a **practical framework**, not an ethical one. It is designed to guide the AI's *behavior*, not to debate abstract principles.
2.  **Alignment with Best Practices:** CHAC's emphasis on adapting to a specific user profile (`chac_profile.md`) and its roots in psychological needs (compensating for executive function and emotional regulation challenges) aligns well with the best practices identified in the literature.
3.  **"Long-Term Impact" Gap:** The report's repeated emphasis on the need for research into the "long-term effects" of compensatory AI strongly validates our choice of a deep, longitudinal, N=1 auto-ethnographic methodology.

### 3.2 Challenge Signals
*   **Conclusion:** **No direct challenges or overlapping frameworks were identified.** The existing practical frameworks are almost exclusively focused on either:
    *   a) Translating a specific, structured therapeutic method (like CBT) into an AI application.
    *   b) Supporting structured learning in an educational context.
*   **The CHAC Niche:** There is a clear absence of frameworks designed for the **open-ended, creative, and strategic domain of knowledge work**. The CHAC framework, which provides a general model for a collaborative *partnership* rather than a specific therapeutic or pedagogical *process*, occupies a distinct and unfilled niche.

## 4.0 Updated Gap Confirmation Heuristic

This analysis allows for an even more precise articulation of our research gap:

> "While the literature has established **[Theme A: ethical frameworks focused on safety]** and **[Theme B: practical frameworks that translate specific therapies like CBT into AI tools]**, there is a clear and significant gap in **[Our Contribution: a practical, partnership-oriented framework (CHAC) designed to provide persistent, compensatory support for the unique cognitive and emotional needs of AuDHD/2e individuals in the context of open-ended knowledge work.]**"