import os
import shutil
import math

def block_assets():
    """
    Organizes renamed assets into blocks of 20.
    """
    base_dir = "/mnt/m/Github/chac-workbench/case-study/A07_Academic_Paper_Preparation_and_Asset_Collection"
    source_dir = os.path.join(base_dir, "A07_renamed_assets")
    dest_dir = os.path.join(base_dir, "A07_blocked_assets")

    # 1. Clean up and create destination directory
    if os.path.exists(dest_dir):
        shutil.rmtree(dest_dir)
    os.makedirs(dest_dir)
    print(f"Created directory: {dest_dir}")

    # 2. Get a sorted list of all files
    try:
        all_files = sorted([f for f in os.listdir(source_dir) if os.path.isfile(os.path.join(source_dir, f))])
    except FileNotFoundError:
        print(f"Error: Source directory not found at {source_dir}")
        return

    if not all_files:
        print("No files found in the source directory to process.")
        return

    # 3. Iterate and copy files in blocks
    block_size = 20
    num_blocks = math.ceil(len(all_files) / block_size)

    for i in range(num_blocks):
        block_num = i + 1
        block_dir = os.path.join(dest_dir, f"block {block_num}")
        os.makedirs(block_dir)
        print(f"Created block directory: {block_dir}")

        start_index = i * block_size
        end_index = start_index + block_size
        block_files = all_files[start_index:end_index]

        for filename in block_files:
            source_path = os.path.join(source_dir, filename)
            dest_path = os.path.join(block_dir, filename)
            shutil.copy2(source_path, dest_path)
            # print(f"  Copied {filename} to block {block_num}")

    print(f"\nBlocking complete. {len(all_files)} files have been organized into {num_blocks} blocks.")

if __name__ == "__main__":
    block_assets()
