# A07 - Record 02: Supplemental Asset List

**Parent Case:** A07_Academic_Paper_Preparation_and_Asset_Collection
**Topic:** A curated list of supplemental assets, identified through a review of case study READMEs, that are essential for the A4S paper.

---

## 1.0 Objective

This document lists critical assets that were not captured by the initial, broad file collection documented in `A07_record_01`. These assets were explicitly mentioned in the summary documents of their respective case studies as being core outputs. This list ensures their inclusion in our evidence base.

## 2.0 Supplemental Asset List & Rationale

### 2.1 Core Implementation Artifacts

These files represent the tangible, engineered outputs of our research. They are the primary evidence that the CHAC framework is not just a theory, but a functioning "Workbench."

*   **File 1:** `/mnt/m/Github/chac-workbench/chac_toolkit/CHAC_System_Prompt_Builder.sh`
    *   **Source:** Mentioned in `A02/README.md`.
    *   **Rationale for Collection:** This script is the ultimate proof of our "Build, Don't Distill" design philosophy. It is the technical implementation of the SOP for creating a portable system prompt and directly supports the "Compensatory Engineering" arguments in Chapter 3 of our paper.

*   **File 2:** `/mnt/m/Github/chac-workbench/case-study/A02_Portable_System_Prompt_Design/build_config.json`
    *   **Source:** Mentioned in `A02/README.md`.
    *   **Rationale for Collection:** As the configuration file for the builder script, it demonstrates the modularity and adaptability of our system architecture.

*   **File 3:** `/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/transform_log.py`
    *   **Source:** Mentioned in `M74/README.md`.
    *   **Rationale for Collection:** This script is the primary evidence for the "Reproducibility of Process" pillar of our AI-Native Auto-Ethnography methodology (Chapter 4). It proves that our raw data (verbatim logs) is structured and can be programmatically analyzed, lending significant weight to the scientific rigor of our N=1 study.

*   **File 4:** `/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/M74_data_schema.md`
    *   **Source:** Mentioned in `M74/README.md`.
    *   **Rationale for Collection:** This schema defines the "ground truth" for our structured data, further strengthening the reproducibility claims.

### 2.2 Foundational Analysis Records

These files contain the detailed, foundational analysis that underpins the high-level synthesis reports. They are the "workings" that justify the conclusions.

*   **File Group 1:** All `.md` files within `case-study/A05_Drafting_the_A4S_Paper/records/`
    *   **Source:** Explicitly cited as essential for a deep understanding in `A05/README.md`.
    *   **Rationale for Collection:** The A05 final reports provide a high-level synthesis of our literature review and academic positioning. However, the 22 atomic records in this directory contain the detailed, step-by-step analysis, debates, and meta-analyses that are the foundational evidence for the conclusions presented in the final paper's "Related Work" section (Chapter 2). They are the primary data source for our claims of having identified a valid research gap.